/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.serde;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.nativetask.serde.DefaultSerializer;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;

@InterfaceAudience.Private
public class NativeSerialization {
    private final ConcurrentHashMap<String, Class<?>> map = new ConcurrentHashMap();
    private static NativeSerialization instance = new NativeSerialization();

    public boolean accept(Class<?> c) {
        return Writable.class.isAssignableFrom(c);
    }

    public INativeSerializer<Writable> getSerializer(Class<?> c) throws IOException {
        if (null == c) {
            return null;
        }
        if (!Writable.class.isAssignableFrom(c)) {
            throw new IOException("Cannot serialize type " + c.getName() + ", we only accept subclass of Writable");
        }
        String name = c.getName();
        Class<?> serializer = this.map.get(name);
        if (null != serializer) {
            try {
                return (INativeSerializer)serializer.newInstance();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return new DefaultSerializer();
    }

    public void register(String klass, Class<?> serializer) throws IOException {
        if (null == klass || null == serializer) {
            throw new IOException("invalid arguments, klass or serializer is null");
        }
        if (!INativeSerializer.class.isAssignableFrom(serializer)) {
            throw new IOException("Serializer is not assigable from INativeSerializer");
        }
        Class<?> storedSerializer = this.map.get(klass);
        if (null == storedSerializer) {
            this.map.put(klass, serializer);
            return;
        }
        if (!storedSerializer.getName().equals(serializer.getName())) {
            throw new IOException("Error! Serializer already registered, existing: " + storedSerializer.getName() + ", new: " + serializer.getName());
        }
    }

    public void reset() {
        this.map.clear();
    }

    public static NativeSerialization getInstance() {
        return instance;
    }
}

