/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;

public class CustomHttpSigner
implements HttpSigner<AwsCredentialsIdentity> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomHttpSigner.class);
    private final HttpSigner<AwsCredentialsIdentity> delegateSigner = AwsV4HttpSigner.create();

    public SignedRequest sign(SignRequest<? extends AwsCredentialsIdentity> request) {
        LOG.trace("Signing request:{}", (Object)request.request());
        return this.delegateSigner.sign(request);
    }

    public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends AwsCredentialsIdentity> request) {
        LOG.trace("Signing async request:{}", (Object)request.request());
        return this.delegateSigner.signAsync(request);
    }
}

