/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsNoOpThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.util.WeakReferenceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AbfsThrottlingInterceptFactory {
    private static AbfsConfiguration abfsConfig;
    private static List<String> lostReferences;
    private static final Logger LOG;
    private static WeakReferenceMap<String, AbfsThrottlingIntercept> interceptMap;

    private AbfsThrottlingInterceptFactory() {
    }

    private static AbfsClientThrottlingIntercept factory(String accountName) {
        return new AbfsClientThrottlingIntercept(accountName, abfsConfig);
    }

    private static void referenceLost(String accountName) {
        lostReferences.add(accountName);
    }

    static synchronized AbfsThrottlingIntercept getInstance(String accountName, AbfsConfiguration abfsConfiguration) {
        AbfsThrottlingIntercept intercept;
        abfsConfig = abfsConfiguration;
        if (!abfsConfiguration.isAutoThrottlingEnabled()) {
            return AbfsNoOpThrottlingIntercept.INSTANCE;
        }
        if (!abfsConfiguration.accountThrottlingEnabled()) {
            intercept = AbfsClientThrottlingIntercept.initializeSingleton(abfsConfiguration);
        } else {
            intercept = (AbfsThrottlingIntercept)interceptMap.get((Object)accountName);
            if (intercept == null) {
                intercept = new AbfsClientThrottlingIntercept(accountName, abfsConfiguration);
                interceptMap.put((Object)accountName, (Object)intercept);
            }
        }
        return intercept;
    }

    static {
        lostReferences = new ArrayList<String>();
        LOG = LoggerFactory.getLogger(AbfsThrottlingInterceptFactory.class);
        interceptMap = new WeakReferenceMap(AbfsThrottlingInterceptFactory::factory, AbfsThrottlingInterceptFactory::referenceLost);
    }
}

