/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;

public final class Actions {
    private Actions() {
    }

    public static Action1<Integer> setAtomic(final AtomicInteger a) {
        return new Action1<Integer>(){

            public void call(Integer t) {
                a.set(t);
            }
        };
    }

    public static Action1<Long> setAtomic(final AtomicLong a) {
        return new Action1<Long>(){

            public void call(Long t) {
                a.set(t);
            }
        };
    }

    public static Action1<Boolean> setAtomic(final AtomicBoolean a) {
        return new Action1<Boolean>(){

            public void call(Boolean t) {
                a.set(t);
            }
        };
    }

    public static <T> Action1<T> setAtomic(final AtomicReference<T> a) {
        return new Action1<T>(){

            public void call(T t) {
                a.set(t);
            }
        };
    }

    public static Action0 doNothing0() {
        return HolderDoNothing0.INSTANCE;
    }

    public static <T> Action1<T> doNothing1() {
        return HolderDoNothing1.INSTANCE;
    }

    public static <T, R> Action2<T, R> doNothing2() {
        return HolderDoNothing2.INSTANCE;
    }

    public static <T, R, S> Action3<T, R, S> doNothing3() {
        return HolderDoNothing3.INSTANCE;
    }

    public static Action0 unsubscribe(final Subscription subscription) {
        return new Action0(){

            public void call() {
                subscription.unsubscribe();
            }
        };
    }

    public static <T> Action1<T> increment1(final AtomicInteger count) {
        return new Action1<T>(){

            public void call(T t) {
                count.incrementAndGet();
            }
        };
    }

    public static Action0 increment0(final AtomicInteger count) {
        return new Action0(){

            public void call() {
                count.incrementAndGet();
            }
        };
    }

    public static <T> Action1<T> decrement1(final AtomicInteger count) {
        return new Action1<T>(){

            public void call(T t) {
                count.incrementAndGet();
            }
        };
    }

    public static Action0 decrement0(final AtomicInteger count) {
        return new Action0(){

            public void call() {
                count.incrementAndGet();
            }
        };
    }

    public static Action1<Long> addTo(final AtomicLong value) {
        return new Action1<Long>(){

            public void call(Long t) {
                value.addAndGet(t);
            }
        };
    }

    public static <T> Action1<T> println() {
        return PrintlnHolder.instance;
    }

    public static <T> Action1<T> setToTrue1(final AtomicBoolean ref) {
        return new Action1<T>(){

            public void call(T t) {
                ref.set(true);
            }
        };
    }

    public static Action0 setToTrue0(final AtomicBoolean ref) {
        return new Action0(){

            public void call() {
                ref.set(true);
            }
        };
    }

    public static Action0 countDown(final CountDownLatch latch) {
        return new Action0(){

            public void call() {
                latch.countDown();
            }
        };
    }

    public static <T> Action1<T> countDown1(final CountDownLatch latch) {
        return new Action1<T>(){

            public void call(T t) {
                latch.countDown();
            }
        };
    }

    public static Action1<Throwable> printStackTrace1() {
        return PrintStackTrace1Holder.instance;
    }

    public static Action0 throw0(final RuntimeException ex) {
        return new Action0(){

            public void call() {
                throw ex;
            }
        };
    }

    public static Action1<Closeable> close() {
        return CloseHolder.INSTANCE;
    }

    public static <T> Action1<T> addTo(final List<T> list) {
        return new Action1<T>(){

            public void call(T t) {
                list.add(t);
            }
        };
    }

    private static final class CloseHolder {
        static final Action1<Closeable> INSTANCE = new Action1<Closeable>(){

            public void call(Closeable c) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private CloseHolder() {
        }
    }

    private static class PrintStackTrace1Holder {
        static final Action1<Throwable> instance = new Action1<Throwable>(){

            public void call(Throwable t) {
                t.printStackTrace();
            }
        };

        private PrintStackTrace1Holder() {
        }
    }

    private static class PrintlnHolder {
        static final Action1<Object> instance = new Action1<Object>(){

            public void call(Object t) {
                System.out.println(t);
            }
        };

        private PrintlnHolder() {
        }
    }

    private static class HolderDoNothing3 {
        static final Action3<Object, Object, Object> INSTANCE = new Action3<Object, Object, Object>(){

            public void call(Object t, Object t2, Object t3) {
            }
        };

        private HolderDoNothing3() {
        }
    }

    private static class HolderDoNothing2 {
        static final Action2<Object, Object> INSTANCE = new Action2<Object, Object>(){

            public void call(Object t, Object t2) {
            }
        };

        private HolderDoNothing2() {
        }
    }

    private static class HolderDoNothing1 {
        static final Action1<Object> INSTANCE = new Action1<Object>(){

            public void call(Object t) {
            }
        };

        private HolderDoNothing1() {
        }
    }

    private static class HolderDoNothing0 {
        static final Action0 INSTANCE = new Action0(){

            public void call() {
            }
        };

        private HolderDoNothing0() {
        }
    }
}

