/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.server;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.Connection;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.SelectorManager;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.AbstractConnector;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Connector;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Server;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.annotation.ManagedObject;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.annotation.Name;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class ConnectionLimit
extends AbstractLifeCycle
implements Connection.Listener,
SelectorManager.AcceptListener {
    private static final Logger LOG = Log.getLogger(ConnectionLimit.class);
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private final Set<SelectableChannel> _accepting = new HashSet<SelectableChannel>();
    private int _connections;
    private int _maxConnections;
    private long _idleTimeout;
    private boolean _limiting = false;

    public ConnectionLimit(@Name(value="maxConnections") int maxConnections, @Name(value="server") Server server) {
        this._maxConnections = maxConnections;
        this._server = server;
    }

    public ConnectionLimit(@Name(value="maxConnections") int maxConnections, Connector ... connectors) {
        this(maxConnections, (Server)null);
        for (Connector c : connectors) {
            if (c instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c);
                continue;
            }
            LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", new Object[]{c});
        }
    }

    @ManagedAttribute(value="The endpoint idle timeout in ms to apply when the connection limit is reached")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="The maximum number of connections allowed")
    public int getMaxConnections() {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            return this._maxConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnections(int max) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._maxConnections = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="The current number of connections ")
    public int getConnections() {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            return this._connections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            if (this._server != null) {
                for (Connector c : this._server.getConnectors()) {
                    if (c instanceof AbstractConnector) {
                        this._connectors.add((AbstractConnector)c);
                        continue;
                    }
                    LOG.warn("Connector {} is not an AbstractConnector. Connections not limited", new Object[]{c});
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionLimit {} for {}", new Object[]{this._maxConnections, this._connectors});
            }
            this._connections = 0;
            this._limiting = false;
            for (AbstractConnector c : this._connectors) {
                c.addBean((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            for (AbstractConnector c : this._connectors) {
                c.removeBean((Object)this);
            }
            this._connections = 0;
            if (this._server != null) {
                this._connectors.clear();
            }
        }
    }

    protected void check() {
        if (this._accepting.size() + this._connections >= this._maxConnections) {
            if (!this._limiting) {
                this._limiting = true;
                LOG.info("Connection Limit({}) reached for {}", new Object[]{this._maxConnections, this._connectors});
                this.limit();
            }
        } else if (this._limiting) {
            this._limiting = false;
            LOG.info("Connection Limit({}) cleared for {}", new Object[]{this._maxConnections, this._connectors});
            this.unlimit();
        }
    }

    protected void limit() {
        for (AbstractConnector c : this._connectors) {
            c.setAccepting(false);
            if (this._idleTimeout <= 0L) continue;
            for (EndPoint endPoint : c.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(this._idleTimeout);
            }
        }
    }

    protected void unlimit() {
        for (AbstractConnector c : this._connectors) {
            c.setAccepting(true);
            if (this._idleTimeout <= 0L) continue;
            for (EndPoint endPoint : c.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(c.getIdleTimeout());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccepting(SelectableChannel channel) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.add(channel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("onAccepting ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, channel});
            }
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.remove(channel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("onAcceptFailed ({}+{}) < {} {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, channel, cause});
            }
            this.check();
        }
    }

    public void onAccepted(SelectableChannel channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened(Connection connection) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            this._accepting.remove(connection.getEndPoint().getTransport());
            ++this._connections;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onOpened ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, connection});
            }
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(Connection connection) {
        ConnectionLimit connectionLimit = this;
        synchronized (connectionLimit) {
            --this._connections;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClosed ({}+{}) < {} {}", new Object[]{this._accepting.size(), this._connections, this._maxConnections, connection});
            }
            this.check();
        }
    }
}

