/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ConnectionPoolId
implements Comparable<ConnectionPoolId> {
    private final String nnId;
    private final UserGroupInformation ugi;
    private final Class<?> protocol;
    private final String ugiString;

    public ConnectionPoolId(UserGroupInformation ugi, String nnId, Class<?> proto) {
        this.nnId = nnId;
        this.ugi = ugi;
        this.protocol = proto;
        this.ugiString = ugi.toString();
    }

    public int hashCode() {
        int hash = new HashCodeBuilder(17, 31).append((Object)this.nnId).append((Object)this.ugiString).append(this.getTokenIds()).append(this.protocol).toHashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ConnectionPoolId) {
            String otherTokens;
            ConnectionPoolId other = (ConnectionPoolId)o;
            if (!this.nnId.equals(other.nnId)) {
                return false;
            }
            if (!this.ugiString.equals(other.ugiString)) {
                return false;
            }
            String thisTokens = this.getTokenIds().toString();
            if (!thisTokens.equals(otherTokens = other.getTokenIds().toString())) {
                return false;
            }
            return this.protocol.equals(other.protocol);
        }
        return false;
    }

    public String toString() {
        return this.ugi + " " + this.getTokenIds() + "->" + this.nnId + " [" + this.protocol.getSimpleName() + "]";
    }

    @Override
    public int compareTo(ConnectionPoolId other) {
        int ret = this.nnId.compareTo(other.nnId);
        if (ret == 0) {
            ret = this.ugi.toString().compareTo(other.ugi.toString());
        }
        if (ret == 0) {
            String thisTokens = this.getTokenIds().toString();
            String otherTokens = other.getTokenIds().toString();
            ret = thisTokens.compareTo(otherTokens);
        }
        if (ret == 0) {
            ret = this.protocol.toString().compareTo(other.protocol.toString());
        }
        return ret;
    }

    @VisibleForTesting
    UserGroupInformation getUgi() {
        return this.ugi;
    }

    private List<String> getTokenIds() {
        ArrayList<String> tokenIds = new ArrayList<String>();
        Collection tokens = this.ugi.getTokens();
        for (Token token : tokens) {
            byte[] tokenIdBytes = token.getIdentifier();
            String tokenId = Arrays.toString(tokenIdBytes);
            tokenIds.add(tokenId);
        }
        Collections.sort(tokenIds);
        return tokenIds;
    }
}

