/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RouterStoragePolicy {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;

    public RouterStoragePolicy(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setStoragePolicy", new Class[]{String.class, String.class}, new RemoteParam(), policyName);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getStoragePolicies");
        return this.rpcServer.invokeAtAvailableNs(method, BlockStoragePolicy[].class);
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("unsetStoragePolicy", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        RemoteMethod method = new RemoteMethod("getStoragePolicy", new Class[]{String.class}, new RemoteParam());
        return (BlockStoragePolicy)this.rpcClient.invokeSequential(locations, method);
    }

    public void satisfyStoragePolicy(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, true, false);
        RemoteMethod method = new RemoteMethod("satisfyStoragePolicy", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, method);
    }
}

