/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActionBase;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContext;

public final class MappingRuleActions {
    public static final String DEFAULT_QUEUE_VARIABLE = "%default";

    private MappingRuleActions() {
    }

    public static MappingRuleAction createUpdateDefaultAction(String queue) {
        return new VariableUpdateAction(DEFAULT_QUEUE_VARIABLE, queue);
    }

    public static MappingRuleAction createPlaceToQueueAction(String queue, boolean allowCreate) {
        return new PlaceToQueueAction(queue, allowCreate);
    }

    public static MappingRuleAction createPlaceToDefaultAction() {
        return MappingRuleActions.createPlaceToQueueAction(DEFAULT_QUEUE_VARIABLE, false);
    }

    public static MappingRuleAction createRejectAction() {
        return new RejectAction();
    }

    public static class VariableUpdateAction
    extends MappingRuleActionBase {
        private final String variableName;
        private final String variableValue;

        VariableUpdateAction(String variableName, String variableValue) {
            this.variableName = variableName;
            this.variableValue = variableValue;
        }

        @Override
        public MappingRuleResult execute(VariableContext variables) {
            variables.put(this.variableName, variables.replaceVariables(this.variableValue));
            return MappingRuleResult.createSkipResult();
        }

        @Override
        public void validate(MappingRuleValidationContext ctx) throws YarnException {
            ctx.addVariable(this.variableName);
        }

        public String toString() {
            return "VariableUpdateAction{variableName='" + this.variableName + '\'' + ", variableValue='" + this.variableValue + '\'' + '}';
        }
    }

    public static class RejectAction
    extends MappingRuleActionBase {
        @Override
        public MappingRuleResult execute(VariableContext variables) {
            return MappingRuleResult.createRejectResult();
        }

        @Override
        public void validate(MappingRuleValidationContext ctx) throws YarnException {
        }

        public String toString() {
            return "RejectAction";
        }
    }

    public static class PlaceToQueueAction
    extends MappingRuleActionBase {
        private String queuePattern;
        private boolean allowCreate;

        PlaceToQueueAction(String queuePattern, boolean allowCreate) {
            this.allowCreate = allowCreate;
            this.queuePattern = queuePattern == null ? "" : queuePattern;
        }

        @Override
        public MappingRuleResult execute(VariableContext variables) {
            String substituted = variables.replacePathVariables(this.queuePattern);
            return MappingRuleResult.createPlacementResult(substituted, this.allowCreate);
        }

        @Override
        public void validate(MappingRuleValidationContext ctx) throws YarnException {
            ctx.validateQueuePath(this.queuePattern);
        }

        public String toString() {
            return "PlaceToQueueAction{queueName='" + this.queuePattern + "',allowCreate=" + this.allowCreate + "}";
        }
    }
}

