/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.Server;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRetryCache {
    private static final byte[] CLIENT_ID = ClientId.getClientId();
    private static int callId = 100;
    private static final Random r = new Random();
    private static final TestServer testServer = new TestServer();

    @Before
    public void setup() {
        testServer.resetCounters();
    }

    public static Server.Call newCall() {
        return new Server.Call(++callId, 1, null, null, RPC.RpcKind.RPC_PROTOCOL_BUFFER, CLIENT_ID);
    }

    @Test
    public void testLongOperationsSuccessful() throws Exception {
        this.testOperations(r.nextInt(), 100, 20, true, false, TestRetryCache.newCall());
    }

    @Test
    public void testLongOperationsFailure() throws Exception {
        this.testOperations(r.nextInt(), 100, 20, false, false, TestRetryCache.newCall());
    }

    @Test
    public void testShortOperationsSuccess() throws Exception {
        this.testOperations(r.nextInt(), 25, 0, false, false, TestRetryCache.newCall());
    }

    @Test
    public void testShortOperationsFailure() throws Exception {
        this.testOperations(r.nextInt(), 25, 0, false, false, TestRetryCache.newCall());
    }

    @Test
    public void testRetryAfterSuccess() throws Exception {
        Server.Call call = TestRetryCache.newCall();
        int input = r.nextInt();
        Server.getCurCall().set(call);
        testServer.echo(input, input + 1, 5L, true);
        this.testOperations(input, 25, 0, true, true, call);
    }

    @Test
    public void testRetryAfterFailure() throws Exception {
        Server.Call call = TestRetryCache.newCall();
        int input = r.nextInt();
        Server.getCurCall().set(call);
        testServer.echo(input, input + 1, 5L, false);
        this.testOperations(input, 25, 0, false, true, call);
    }

    public void testOperations(int input, int numberOfThreads, int pause, boolean success, boolean attemptedBefore, Server.Call call) throws InterruptedException, ExecutionException {
        int failureOutput = input + 1;
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads);
        ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
        for (int i = 0; i < numberOfThreads; ++i) {
            Callable<Integer> callable = () -> {
                Server.getCurCall().set(call);
                Assert.assertEquals(Server.getCurCall().get(), (Object)call);
                int randomPause = pause == 0 ? pause : r.nextInt(pause);
                return testServer.echo(input, failureOutput, randomPause, success);
            };
            Future<Integer> submit = executorService.submit(callable);
            list.add(submit);
        }
        Assert.assertEquals((long)numberOfThreads, (long)list.size());
        for (Future future : list) {
            if (success) {
                Assert.assertEquals((long)input, (long)((Integer)future.get()).intValue());
                continue;
            }
            Assert.assertEquals((long)failureOutput, (long)((Integer)future.get()).intValue());
        }
        if (success) {
            int retries = numberOfThreads + (attemptedBefore ? 0 : -1);
            Assert.assertEquals((long)1L, (long)TestRetryCache.testServer.operationCount.get());
            Assert.assertEquals((long)retries, (long)TestRetryCache.testServer.retryCount.get());
        } else {
            int opCount = numberOfThreads + (attemptedBefore ? 1 : 0);
            Assert.assertEquals((long)opCount, (long)TestRetryCache.testServer.operationCount.get());
            Assert.assertEquals((long)0L, (long)TestRetryCache.testServer.retryCount.get());
        }
    }

    static class TestServer {
        AtomicInteger retryCount = new AtomicInteger();
        AtomicInteger operationCount = new AtomicInteger();
        private final RetryCache retryCache = new RetryCache("TestRetryCache", 1.0, 100000000000L);

        TestServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int echo(int input, int failureOutput, long methodTime, boolean success) throws InterruptedException {
            RetryCache.CacheEntryWithPayload entry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null, (byte[])Server.getClientId(), (int)Server.getCallId());
            if (entry != null && entry.isSuccess()) {
                System.out.println("retryCount incremented " + this.retryCount.get());
                this.retryCount.incrementAndGet();
                return (Integer)entry.getPayload();
            }
            try {
                this.operationCount.incrementAndGet();
                if (methodTime > 0L) {
                    Thread.sleep(methodTime);
                }
            }
            finally {
                RetryCache.setState((RetryCache.CacheEntryWithPayload)entry, (boolean)success, (Object)input);
            }
            return success ? input : failureOutput;
        }

        void resetCounters() {
            this.retryCount.set(0);
            this.operationCount.set(0);
        }
    }
}

