/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;

public final class OperatorSampleFirst<T>
implements Observable.Operator<T, T> {
    private final long windowDurationMs;
    private final Scheduler scheduler;
    private static long UNSET = Long.MIN_VALUE;

    public OperatorSampleFirst(long windowDurationMs, TimeUnit unit, Scheduler scheduler) {
        this.windowDurationMs = unit.toMillis(windowDurationMs);
        this.scheduler = scheduler;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private long nextWindowStartTime;
            {
                super(x0);
                this.nextWindowStartTime = UNSET;
            }

            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                long now = OperatorSampleFirst.this.scheduler.now();
                if (this.nextWindowStartTime == UNSET) {
                    this.nextWindowStartTime = now + OperatorSampleFirst.this.windowDurationMs;
                    subscriber.onNext(t);
                } else if (now >= this.nextWindowStartTime) {
                    long n = (now - this.nextWindowStartTime) / OperatorSampleFirst.this.windowDurationMs + 1L;
                    this.nextWindowStartTime += n * OperatorSampleFirst.this.windowDurationMs;
                    subscriber.onNext(t);
                }
            }

            public void onCompleted() {
                subscriber.onCompleted();
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }
        };
    }
}

