/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services.retryReasonCategories;

import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.RetryReasonCategory;

public class ServerErrorRetryReason
extends RetryReasonCategory {
    @Override
    Boolean canCapture(Exception ex, Integer statusCode, String serverErrorMessage) {
        if (statusCode == null || statusCode / AbfsHttpConstants.HTTP_STATUS_CATEGORY_QUOTIENT != 5) {
            return false;
        }
        return true;
    }

    @Override
    String getAbbreviation(Integer statusCode, String serverErrorMessage) {
        if (statusCode == 503 && serverErrorMessage != null) {
            String splitedServerErrorMessage = serverErrorMessage.split(System.lineSeparator(), 2)[0];
            if (AzureServiceErrorCode.INGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage().equalsIgnoreCase(splitedServerErrorMessage)) {
                return "ING";
            }
            if (AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage().equalsIgnoreCase(splitedServerErrorMessage)) {
                return "EGR";
            }
            if (AzureServiceErrorCode.TPS_OVER_ACCOUNT_LIMIT.getErrorMessage().equalsIgnoreCase(splitedServerErrorMessage)) {
                return "OPR";
            }
            if (AzureServiceErrorCode.OTHER_SERVER_THROTTLING.getErrorMessage().equalsIgnoreCase(splitedServerErrorMessage)) {
                return "OTH";
            }
            return "503";
        }
        return statusCode + "";
    }
}

