/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import java.util.List;
import java.util.TreeSet;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;

public class CoordinatedSet<K extends Comparable<? super K>> {
    private final PrimitiveSeries[] myCoordinated;
    private final K myFirstKey;
    private final K myLastKey;

    public static <K extends Comparable<? super K>> CoordinatedSet<K> from(List<? extends BasicSeries<K, ?>> uncoordinated) {
        Object first = BasicSeries.findLatestFirstKey(uncoordinated);
        Object last = BasicSeries.findEarliestLastKey(uncoordinated);
        TreeSet tmpAllKeys = new TreeSet();
        for (BasicSeries individual : uncoordinated) {
            tmpAllKeys.addAll(individual.subMap(first, last).keySet());
        }
        tmpAllKeys.add(last);
        int numberOfSeries = uncoordinated.size();
        int numberOfKeys = tmpAllKeys.size();
        PrimitiveSeries[] coordinated = new PrimitiveSeries[numberOfSeries];
        for (int s = 0; s < numberOfSeries; ++s) {
            BasicSeries<Comparable, ?> inputSeries = uncoordinated.get(s);
            double[] outputSeries = new double[numberOfKeys];
            double tmpVal = Double.NaN;
            double curVal = Double.NaN;
            int k = 0;
            for (Comparable key : tmpAllKeys) {
                tmpVal = inputSeries.doubleValue(key);
                if (Double.isNaN(tmpVal)) {
                    tmpVal = curVal;
                }
                outputSeries[k] = tmpVal;
                curVal = tmpVal;
                ++k;
            }
            coordinated[s] = DataSeries.wrap(outputSeries);
        }
        return new CoordinatedSet(coordinated, first, last);
    }

    private CoordinatedSet(PrimitiveSeries[] coordinated, K first, K last) {
        this.myCoordinated = coordinated;
        this.myFirstKey = first;
        this.myLastKey = last;
    }

    public K getFirstKey() {
        return this.myFirstKey;
    }

    public K getLastKey() {
        return this.myLastKey;
    }

    public PrimitiveSeries getSeries(int index) {
        return this.myCoordinated[index];
    }

    public int size() {
        return this.myCoordinated.length;
    }
}

