/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.javax.websocket.security.DeclareRoles;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.apache.hadoop.shaded.org.eclipse.jetty.security.ConstraintAware;
import org.apache.hadoop.shaded.org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class DeclareRolesAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(DeclareRolesAnnotationHandler.class);
    protected WebAppContext _context;

    public DeclareRolesAnnotationHandler(WebAppContext context) {
        super(false);
        this._context = context;
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing", new Object[0]);
            return;
        }
        DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
        if (declareRoles == null) {
            return;
        }
        String[] roles = declareRoles.value();
        if (roles != null && roles.length > 0) {
            for (String r : roles) {
                ((ConstraintSecurityHandler)this._context.getSecurityHandler()).addRole(r);
            }
        }
    }
}

