/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.ContentSummary;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.DirectoryEntryListWithContinuationToken;
import com.microsoft.azure.datalake.store.DirectoryEntryType;
import com.microsoft.azure.datalake.store.ExpiryOption;
import com.microsoft.azure.datalake.store.HttpTransport;
import com.microsoft.azure.datalake.store.Operation;
import com.microsoft.azure.datalake.store.OperationResponse;
import com.microsoft.azure.datalake.store.QueryParams;
import com.microsoft.azure.datalake.store.RequestOptions;
import com.microsoft.azure.datalake.store.SyncFlag;
import com.microsoft.azure.datalake.store.UserGroupRepresentation;
import com.microsoft.azure.datalake.store.acl.AclEntry;
import com.microsoft.azure.datalake.store.acl.AclStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class Core {
    private static final Pattern octalPattern = Pattern.compile("[01]?[0-7]?[0-7]?[0-7]");
    private static final Pattern rwxPattern = Pattern.compile("[r-][w-][x-]");

    private Core() {
    }

    public static void create(String path, boolean overwrite, String octalPermission, byte[] contents, int offsetWithinContentsArray, int length, String leaseId, String sessionId, boolean createParent, SyncFlag syncFlag, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        qp.add("overwrite", Boolean.toString(overwrite));
        qp.add("syncFlag", syncFlag.name());
        qp.add("write", "true");
        if (leaseId != null && !leaseId.equals("")) {
            qp.add("leaseid", leaseId);
        }
        if (sessionId != null && !sessionId.equals("")) {
            qp.add("filesessionid", sessionId);
        }
        if (!createParent) {
            qp.add("CreateParent", "false");
        }
        if (octalPermission != null && !octalPermission.equals("")) {
            if (Core.isValidOctal(octalPermission)) {
                qp.add("permission", octalPermission);
            } else {
                resp.successful = false;
                resp.message = "Invalid directory permissions specified: " + octalPermission;
                return;
            }
        }
        HttpTransport.makeCall(client, Operation.CREATE, path, qp, contents, offsetWithinContentsArray, length, opts, resp);
    }

    public static void append(String path, long offsetToAppendTo, byte[] contents, int offsetWithinContentsArray, int length, String leaseId, String sessionId, SyncFlag syncFlag, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        qp.add("append", "true");
        qp.add("syncFlag", syncFlag.name());
        if (leaseId != null && !leaseId.equals("")) {
            qp.add("leaseid", leaseId);
        }
        if (sessionId != null && !sessionId.equals("")) {
            qp.add("filesessionid", sessionId);
        }
        if (offsetToAppendTo >= 0L) {
            qp.add("offset", Long.toString(offsetToAppendTo));
        }
        HttpTransport.makeCall(client, Operation.APPEND, path, qp, contents, offsetWithinContentsArray, length, opts, resp);
    }

    public static void concurrentAppend(String path, byte[] contents, int offsetWithinContentsArray, int length, boolean autoCreate, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        if (autoCreate) {
            qp.add("appendMode", "autocreate");
        }
        HttpTransport.makeCall(client, Operation.CONCURRENTAPPEND, path, qp, contents, offsetWithinContentsArray, length, opts, resp);
    }

    public static InputStream open(String path, long offset, long length, String sessionId, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        return Core.open(path, offset, length, sessionId, false, client, opts, resp);
    }

    public static InputStream open(String path, long offset, long length, String sessionId, boolean speculativeRead, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        qp.add("read", "true");
        if (offset < 0L) {
            resp.successful = false;
            resp.message = "attempt to read from negative offset: " + offset;
            return null;
        }
        if (length < 0L) {
            resp.successful = false;
            resp.message = "attempt to read negative length: " + length;
            return null;
        }
        if (offset > 0L) {
            qp.add("offset", Long.toString(offset));
        }
        if (length > 0L) {
            qp.add("length", Long.toString(length));
        }
        if (speculativeRead) {
            qp.add("speculative", "true");
        }
        if (sessionId != null && !sessionId.equals("")) {
            qp.add("filesessionid", sessionId);
        }
        HttpTransport.makeCall(client, Operation.OPEN, path, qp, null, 0, 0, opts, resp);
        if (resp.successful) {
            return resp.responseStream;
        }
        return null;
    }

    public static boolean delete(String path, boolean recursive, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        return Core.delete(path, recursive, null, client, opts, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean delete(String path, boolean recursive, String fileContextId, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        qp.add("recursive", recursive ? "true" : "false");
        if (fileContextId != null) {
            qp.add("fileContextId", fileContextId);
        }
        HttpTransport.makeCall(client, Operation.DELETE, path, qp, null, 0, 0, opts, resp);
        if (!resp.successful) {
            return false;
        }
        boolean returnValue = true;
        try {
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(resp.responseStream);
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            returnValue = jp.getValueAsBoolean();
            jp.nextToken();
            jp.close();
        }
        catch (IOException ex) {
            resp.successful = false;
            resp.message = "Unexpected error happened reading response stream or parsing JSon from delete()";
        }
        finally {
            try {
                resp.responseStream.close();
            }
            catch (IOException iOException) {}
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rename(String path, String destination, boolean overwrite, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (destination == null || destination.equals("")) {
            throw new IllegalArgumentException("destination cannot be null or empty");
        }
        String prefix = client.getFilePathPrefix();
        if (prefix != null) {
            destination = destination.charAt(0) == '/' ? prefix + destination : prefix + "/" + destination;
        }
        QueryParams qp = new QueryParams();
        qp.add("destination", destination);
        if (overwrite) {
            qp.add("renameoptions", "OVERWRITE");
        }
        HttpTransport.makeCall(client, Operation.RENAME, path, qp, null, 0, 0, opts, resp);
        if (!resp.successful) {
            return false;
        }
        boolean returnValue = true;
        try {
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(resp.responseStream);
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            returnValue = jp.getValueAsBoolean();
            jp.nextToken();
            jp.close();
        }
        catch (IOException ex) {
            resp.successful = false;
            resp.message = "Unexpected error happened reading response stream or parsing JSon from rename()";
        }
        finally {
            try {
                resp.responseStream.close();
            }
            catch (IOException iOException) {}
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mkdirs(String path, String octalPermission, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        if (octalPermission != null && !octalPermission.equals("")) {
            if (Core.isValidOctal(octalPermission)) {
                qp.add("permission", octalPermission);
            } else {
                resp.successful = false;
                resp.message = "Invalid directory permissions specified: " + octalPermission;
                return false;
            }
        }
        HttpTransport.makeCall(client, Operation.MKDIRS, path, qp, null, 0, 0, opts, resp);
        if (!resp.successful) {
            return false;
        }
        boolean returnValue = true;
        try {
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(resp.responseStream);
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            returnValue = jp.getValueAsBoolean();
            jp.nextToken();
            jp.close();
        }
        catch (IOException ex) {
            resp.successful = false;
            resp.message = "Unexpected error happened reading response stream or parsing JSon from mkdirs()";
        }
        finally {
            try {
                resp.responseStream.close();
            }
            catch (IOException iOException) {}
        }
        return returnValue;
    }

    public static void setExpiryTime(String path, ExpiryOption expiryOption, long milliseconds, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (expiryOption == null) {
            resp.successful = false;
            resp.message = "null ExpiryOption passed to setExpiryTime";
            return;
        }
        if (milliseconds < 0L) {
            resp.successful = false;
            resp.message = "Expiry time is negative " + Long.toString(milliseconds);
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("expiryOption", expiryOption.toString());
        qp.add("expireTime", Long.toString(milliseconds));
        HttpTransport.makeCall(client, Operation.SETEXPIRY, path, qp, null, 0, 0, opts, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSummary getContentSummary(String path, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        HttpTransport.makeCall(client, Operation.GETCONTENTSUMMARY, path, null, null, 0, 0, opts, resp);
        if (!resp.successful) {
            return null;
        }
        try {
            long length = 0L;
            long directoryCount = 0L;
            long fileCount = 0L;
            long spaceConsumed = 0L;
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(resp.responseStream);
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("length")) {
                        length = Long.parseLong(fieldValue);
                    }
                    if (fieldName.equals("directoryCount")) {
                        directoryCount = Long.parseLong(fieldValue);
                    }
                    if (fieldName.equals("fileCount")) {
                        fileCount = Long.parseLong(fieldValue);
                    }
                    if (fieldName.equals("spaceConsumed")) {
                        spaceConsumed = Long.parseLong(fieldValue);
                    }
                }
                jp.nextToken();
            }
            jp.close();
            ContentSummary contentSummary = new ContentSummary(length, directoryCount, fileCount, spaceConsumed);
            return contentSummary;
        }
        catch (IOException ex) {
            resp.successful = false;
            resp.message = "Unexpected error happened reading response stream or parsing JSon from getContentSummary()";
            ContentSummary contentSummary = null;
            return contentSummary;
        }
        finally {
            try {
                resp.responseStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void concat(String path, List<String> sources, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        Core.concat(path, sources, client, false, opts, resp);
    }

    public static void concat(String path, List<String> sources, ADLStoreClient client, boolean deleteSourceDirectory, RequestOptions opts, OperationResponse resp) {
        byte[] body;
        block10: {
            if (sources == null || sources.size() == 0) {
                resp.successful = false;
                resp.message = "No source files specified to concatenate";
                return;
            }
            body = null;
            JsonStringEncoder jsonEncoder = JsonStringEncoder.getInstance();
            StringBuilder sb = new StringBuilder("{\"sources\":[");
            boolean firstelem = true;
            HashSet<String> pathSet = new HashSet<String>(4096);
            for (String item : sources) {
                if (item.equals(path)) {
                    resp.successful = false;
                    resp.message = "One of the source files to concatenate is the destination file";
                    return;
                }
                if (pathSet.contains(item)) {
                    resp.successful = false;
                    resp.message = "concat() source list contains a file more than once: " + item;
                    return;
                }
                pathSet.add(item);
                String prefix = client.getFilePathPrefix();
                if (prefix != null) {
                    item = item.charAt(0) == '/' ? prefix + item : prefix + "/" + item;
                }
                if (!firstelem) {
                    sb.append(',');
                } else {
                    firstelem = false;
                }
                sb.append("\"").append(jsonEncoder.quoteAsString(item)).append("\"");
            }
            sb.append("]}");
            try {
                body = sb.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)"UTF-8 encoding is not supported");
            }
        }
        QueryParams qp = null;
        if (deleteSourceDirectory) {
            qp = new QueryParams();
            qp.add("deleteSourceDirectory", "true");
        }
        HttpTransport.makeCall(client, Operation.MSCONCAT, path, qp, body, 0, body.length, opts, resp);
    }

    public static DirectoryEntry getFileStatus(String path, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        return Core.getFileStatus(path, null, client, opts, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryEntry getFileStatus(String path, UserGroupRepresentation oidOrUpn, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        if (oidOrUpn == null) {
            oidOrUpn = UserGroupRepresentation.OID;
        }
        String tooid = oidOrUpn == UserGroupRepresentation.OID ? "true" : "false";
        qp.add("tooid", tooid);
        HttpTransport.makeCall(client, Operation.GETFILESTATUS, path, qp, null, 0, 0, opts, resp);
        if (resp.successful) {
            try {
                String name = "";
                String fullName = "";
                long length = 0L;
                String group = "";
                String user = "";
                Date lastAccessTime = null;
                Date lastModifiedTime = null;
                DirectoryEntryType type = null;
                String permission = "";
                int replicationFactor = 1;
                long blocksize = 0x10000000L;
                boolean aclBit = true;
                Date expiryTime = null;
                String fileContextId = null;
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(resp.responseStream);
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        long expiryms;
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("length")) {
                            length = Long.parseLong(fieldValue);
                        }
                        if (fieldName.equals("type")) {
                            type = DirectoryEntryType.valueOf(fieldValue);
                        }
                        if (fieldName.equals("accessTime")) {
                            lastAccessTime = new Date(Long.parseLong(fieldValue));
                        }
                        if (fieldName.equals("modificationTime")) {
                            lastModifiedTime = new Date(Long.parseLong(fieldValue));
                        }
                        if (fieldName.equals("permission")) {
                            permission = fieldValue;
                        }
                        if (fieldName.equals("owner")) {
                            user = fieldValue;
                        }
                        if (fieldName.equals("group")) {
                            group = fieldValue;
                        }
                        if (fieldName.equals("blockSize")) {
                            blocksize = Long.parseLong(fieldValue);
                        }
                        if (fieldName.equals("replication")) {
                            replicationFactor = Integer.parseInt(fieldValue);
                        }
                        if (fieldName.equals("aclBit")) {
                            aclBit = Boolean.parseBoolean(fieldValue);
                        }
                        if (fieldName.equals("msExpirationTime") && (expiryms = Long.parseLong(fieldValue)) > 0L) {
                            expiryTime = new Date(expiryms);
                        }
                        if (fieldName.equals("fileContextID")) {
                            fileContextId = fieldValue;
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                fullName = path;
                name = path.substring(path.lastIndexOf("/") + 1);
                DirectoryEntry directoryEntry = new DirectoryEntry(name, fullName, length, group, user, lastAccessTime, lastModifiedTime, type, blocksize, replicationFactor, permission, aclBit, expiryTime, fileContextId);
                return directoryEntry;
            }
            catch (IOException ex) {
                resp.successful = false;
                resp.message = "Unexpected error happened reading response stream or parsing JSon from getFileStatus()";
            }
            finally {
                try {
                    resp.responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static List<DirectoryEntry> listStatus(String path, String listAfter, String listBefore, int listSize, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        return Core.listStatus(path, listAfter, listBefore, listSize, null, client, opts, resp);
    }

    public static List<DirectoryEntry> listStatus(String path, String listAfter, String listBefore, int listSize, UserGroupRepresentation oidOrUpn, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        DirectoryEntryListWithContinuationToken val = Core.listStatusWithToken(path, listAfter, listBefore, listSize, oidOrUpn, client, opts, resp);
        return val.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryEntryListWithContinuationToken listStatusWithToken(String path, String listAfter, String listBefore, int listSize, UserGroupRepresentation oidOrUpn, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        DirectoryEntryListWithContinuationToken ret = new DirectoryEntryListWithContinuationToken();
        QueryParams qp = new QueryParams();
        if (listAfter != null && !listAfter.equals("")) {
            qp.add("listAfter", listAfter);
        }
        if (listBefore != null && !listBefore.equals("")) {
            qp.add("listBefore", listBefore);
        }
        if (listSize > 0) {
            qp.add("listSize", Integer.toString(listSize));
        }
        if (oidOrUpn == null) {
            oidOrUpn = UserGroupRepresentation.OID;
        }
        String tooid = oidOrUpn == UserGroupRepresentation.OID ? "true" : "false";
        qp.add("tooid", tooid);
        HttpTransport.makeCall(client, Operation.LISTSTATUS, path, qp, null, 0, 0, opts, resp);
        if (resp.successful) {
            ArrayList<DirectoryEntry> list = new ArrayList<DirectoryEntry>();
            try {
                String name = "";
                String fullName = "";
                long length = 0L;
                String group = "";
                String user = "";
                Date lastAccessTime = null;
                Date lastModifiedTime = null;
                DirectoryEntryType type = null;
                String permission = "";
                int replicationFactor = 1;
                long blocksize = 0x10000000L;
                boolean aclBit = true;
                Date expiryTime = null;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(resp.responseStream);
                block11: while (jp.nextToken() != JsonToken.END_OBJECT) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME && jp.getText() == "continuationToken") {
                        jp.nextToken();
                        ret.setContinuationToken(jp.getText());
                        continue;
                    }
                    if (jp.getCurrentToken() != JsonToken.FIELD_NAME || jp.getText() != "FileStatus") continue;
                    jp.nextToken();
                    jp.nextToken();
                    while (jp.hasCurrentToken()) {
                        if (jp.getCurrentToken() == JsonToken.END_OBJECT) {
                            fullName = "".equals(name) ? path : path + name;
                            DirectoryEntry entry = new DirectoryEntry(name, fullName, length, group, user, lastAccessTime, lastModifiedTime, type, blocksize, replicationFactor, permission, aclBit, expiryTime);
                            list.add(entry);
                        }
                        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                            String fieldName = jp.getCurrentName();
                            jp.nextToken();
                            String fieldValue = jp.getText();
                            if (fieldName.equals("length")) {
                                length = Long.parseLong(fieldValue);
                            }
                            if (fieldName.equals("pathSuffix")) {
                                name = fieldValue;
                            }
                            if (fieldName.equals("type")) {
                                type = DirectoryEntryType.valueOf(fieldValue);
                            }
                            if (fieldName.equals("accessTime")) {
                                lastAccessTime = new Date(Long.parseLong(fieldValue));
                            }
                            if (fieldName.equals("modificationTime")) {
                                lastModifiedTime = new Date(Long.parseLong(fieldValue));
                            }
                            if (fieldName.equals("permission")) {
                                permission = fieldValue;
                            }
                            if (fieldName.equals("owner")) {
                                user = fieldValue;
                            }
                            if (fieldName.equals("group")) {
                                group = fieldValue;
                            }
                            if (fieldName.equals("blockSize")) {
                                blocksize = Long.parseLong(fieldValue);
                            }
                            if (fieldName.equals("replication")) {
                                replicationFactor = Integer.parseInt(fieldValue);
                            }
                            if (fieldName.equals("aclBit")) {
                                aclBit = Boolean.parseBoolean(fieldValue);
                            }
                            if (fieldName.equals("msExpirationTime")) {
                                long expiryms = Long.parseLong(fieldValue);
                                Date date = expiryTime = expiryms > 0L ? new Date(expiryms) : null;
                            }
                        }
                        if (jp.getCurrentToken() == JsonToken.END_ARRAY) continue block11;
                        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
                            int startArraysEncountered = 0;
                            while (jp.hasCurrentToken()) {
                                jp.nextToken();
                                if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
                                    ++startArraysEncountered;
                                }
                                if (jp.getCurrentToken() != JsonToken.END_ARRAY || startArraysEncountered-- > 0) continue;
                            }
                        }
                        jp.nextToken();
                    }
                }
                jp.nextToken();
                jp.close();
                ret.setEntries(list);
                DirectoryEntryListWithContinuationToken directoryEntryListWithContinuationToken = ret;
                return directoryEntryListWithContinuationToken;
            }
            catch (IOException ex) {
                resp.successful = false;
                resp.message = "Unexpected error happened reading response stream or parsing JSon from listFiles()";
            }
            finally {
                try {
                    resp.responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public static void setTimes(String path, long atime, long mtime, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (atime < -1L) {
            resp.message = "Invalid Access Time specified";
            resp.successful = false;
            return;
        }
        if (mtime < -1L) {
            resp.message = "Invalid Modification Time specified";
            resp.successful = false;
            return;
        }
        if (atime == -1L && mtime == -1L) {
            resp.message = "Access time and Modification time cannot both be unspecified";
        }
        QueryParams qp = new QueryParams();
        if (mtime != -1L) {
            qp.add("modificationtime", Long.toString(mtime));
        }
        if (atime != -1L) {
            qp.add("accesstime", Long.toString(atime));
        }
        HttpTransport.makeCall(client, Operation.SETTIMES, path, qp, null, 0, 0, opts, resp);
    }

    public static void setOwner(String path, String user, String group, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if ((user == null || user.equals("")) && (group == null || group.equals(""))) {
            resp.successful = false;
            resp.message = "Both user and owner names cannot be blank";
            return;
        }
        QueryParams qp = new QueryParams();
        if (user != null && !user.equals("")) {
            qp.add("owner", user);
        }
        if (group != null && !group.equals("")) {
            qp.add("group", group);
        }
        HttpTransport.makeCall(client, Operation.SETOWNER, path, qp, null, 0, 0, opts, resp);
    }

    public static void setPermission(String path, String octalPermissions, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (!Core.isValidOctal(octalPermissions)) {
            resp.message = "Specified permissions are not valid Octal Permissions: " + octalPermissions;
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("permission", octalPermissions);
        HttpTransport.makeCall(client, Operation.SETPERMISSION, path, qp, null, 0, 0, opts, resp);
    }

    public static boolean isValidOctal(String input) {
        return octalPattern.matcher(input).matches();
    }

    public static void checkAccess(String path, String rwx, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (rwx == null || rwx.trim().equals("")) {
            resp.message = "null or empty access specification passed in to check access for";
            resp.successful = false;
            return;
        }
        if (!Core.isValidRwx(rwx)) {
            resp.message = "invalid access specification passed in to check access for: " + rwx;
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("fsaction", rwx);
        HttpTransport.makeCall(client, Operation.CHECKACCESS, path, qp, null, 0, 0, opts, resp);
    }

    private static boolean isValidRwx(String input) {
        input = input.trim().toLowerCase();
        return rwxPattern.matcher(input).matches();
    }

    public static void modifyAclEntries(String path, String aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.trim().equals("")) {
            resp.message = "null or empty AclSpec passed in to modifyAclEntries";
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("aclspec", aclSpec);
        HttpTransport.makeCall(client, Operation.MODIFYACLENTRIES, path, qp, null, 0, 0, opts, resp);
    }

    public static void modifyAclEntries(String path, List<AclEntry> aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.size() == 0) {
            resp.message = "null or empty AclSpec passed in to modifyAclEntries";
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("aclspec", AclEntry.aclListToString(aclSpec));
        HttpTransport.makeCall(client, Operation.MODIFYACLENTRIES, path, qp, null, 0, 0, opts, resp);
    }

    public static void removeAclEntries(String path, String aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.trim().equals("")) {
            resp.message = "null or empty AclSpec passed in to removeAclEntries";
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("aclspec", aclSpec);
        HttpTransport.makeCall(client, Operation.REMOVEACLENTRIES, path, qp, null, 0, 0, opts, resp);
    }

    public static void removeAclEntries(String path, List<AclEntry> aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.size() == 0) {
            resp.message = "null or empty AclSpec passed in to removeAclEntries";
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("aclspec", AclEntry.aclListToString(aclSpec, true));
        HttpTransport.makeCall(client, Operation.REMOVEACLENTRIES, path, qp, null, 0, 0, opts, resp);
    }

    public static void removeDefaultAcl(String path, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        HttpTransport.makeCall(client, Operation.REMOVEDEFAULTACL, path, null, null, 0, 0, opts, resp);
    }

    public static void removeAcl(String path, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        HttpTransport.makeCall(client, Operation.REMOVEACL, path, null, null, 0, 0, opts, resp);
    }

    public static void setAcl(String path, String aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.trim().equals("")) {
            resp.message = "null or empty AclSpec passed in to setAcl";
            resp.successful = false;
            return;
        }
        QueryParams qp = new QueryParams();
        qp.add("aclspec", aclSpec);
        HttpTransport.makeCall(client, Operation.SETACL, path, qp, null, 0, 0, opts, resp);
    }

    public static void setAcl(String path, List<AclEntry> aclSpec, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        if (aclSpec == null || aclSpec.size() == 0) {
            resp.message = "null or empty AclSpec passed in to setAcl";
            resp.successful = false;
            return;
        }
        Core.setAcl(path, AclEntry.aclListToString(aclSpec), client, opts, resp);
    }

    public static AclStatus getAclStatus(String path, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        return Core.getAclStatus(path, null, client, opts, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AclStatus getAclStatus(String path, UserGroupRepresentation oidOrUpn, ADLStoreClient client, RequestOptions opts, OperationResponse resp) {
        QueryParams qp = new QueryParams();
        if (oidOrUpn == null) {
            oidOrUpn = UserGroupRepresentation.OID;
        }
        String tooid = oidOrUpn == UserGroupRepresentation.OID ? "true" : "false";
        qp.add("tooid", tooid);
        HttpTransport.makeCall(client, Operation.GETACLSTATUS, path, qp, null, 0, 0, opts, resp);
        if (resp.successful) {
            AclStatus status = new AclStatus();
            ArrayList<AclEntry> list = new ArrayList<AclEntry>();
            status.aclSpec = list;
            try {
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(resp.responseStream);
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        if (fieldName.equals("entries")) {
                            jp.nextToken();
                            jp.nextToken();
                            while (jp.hasCurrentToken() && jp.getCurrentToken() != JsonToken.END_ARRAY) {
                                String aclEntryString = jp.getText();
                                AclEntry aclEntry = AclEntry.parseAclEntry(aclEntryString);
                                list.add(aclEntry);
                                jp.nextToken();
                            }
                            jp.nextToken();
                            continue;
                        }
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("group")) {
                            status.group = fieldValue;
                        }
                        if (fieldName.equals("owner")) {
                            status.owner = fieldValue;
                        }
                        if (fieldName.equals("permission")) {
                            status.octalPermissions = fieldValue;
                        }
                        if (fieldName.equals("stickyBit")) {
                            status.stickyBit = Boolean.valueOf(fieldValue);
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                AclStatus aclStatus = status;
                return aclStatus;
            }
            catch (IOException ex) {
                resp.successful = false;
                resp.message = "Unexpected error happened reading response stream or parsing JSon from getAclStatus";
                AclStatus aclStatus = null;
                return aclStatus;
            }
            finally {
                try {
                    resp.responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

