/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import java.util.List;
import org.apache.ignite3.configuration.RootKey;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.internal.configuration.SuperRoot;
import org.apache.ignite3.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite3.internal.configuration.util.KeyNotFoundException;
import org.jetbrains.annotations.Nullable;

class ValidationContextImpl<VIEWT>
implements ValidationContext<VIEWT> {
    private final SuperRoot oldRoots;
    private final SuperRoot newRoots;
    private final VIEWT val;
    private final String currentKey;
    private final List<String> currentPath;
    private final List<ValidationIssue> issues;

    ValidationContextImpl(SuperRoot oldRoots, SuperRoot newRoots, VIEWT val, String currentKey, List<String> currentPath, List<ValidationIssue> issues) {
        this.oldRoots = oldRoots;
        this.newRoots = newRoots;
        this.val = val;
        this.currentKey = currentKey;
        this.currentPath = currentPath;
        this.issues = issues;
        assert (!currentPath.isEmpty());
    }

    @Override
    public String currentKey() {
        return this.currentKey;
    }

    @Override
    public VIEWT getOldValue() {
        try {
            return (VIEWT)ConfigurationUtil.find(this.currentPath, this.oldRoots, true).value();
        }
        catch (KeyNotFoundException ignore) {
            return null;
        }
    }

    @Override
    public VIEWT getNewValue() {
        return this.val;
    }

    @Override
    public <ROOT> ROOT getOldRoot(RootKey<?, ROOT, ?> rootKey) {
        return (ROOT)this.oldRoots.getRoot(rootKey);
    }

    @Override
    public <ROOT> ROOT getNewRoot(RootKey<?, ROOT, ?> rootKey) {
        return (ROOT)this.newRoots.getRoot(rootKey);
    }

    @Override
    public void addIssue(ValidationIssue issue) {
        this.issues.add(issue);
    }

    @Override
    @Nullable
    public <T> T getOldOwner() {
        return this.findOwner(this.oldRoots);
    }

    @Override
    @Nullable
    public <T> T getNewOwner() {
        return this.findOwner(this.newRoots);
    }

    @Nullable
    private <T> T findOwner(SuperRoot superRoot) {
        try {
            return this.currentPath.size() <= 1 ? null : (T)ConfigurationUtil.find(this.currentPath.subList(0, this.currentPath.size() - 1), superRoot, true).value();
        }
        catch (KeyNotFoundException ignore) {
            return null;
        }
    }
}

