/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore.status;

import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.metastore.status.UnitKey;
import org.apache.ignite3.internal.lang.ByteArray;

public class ClusterStatusKey {
    private static final String UNITS_PREFIX = "deploy-unit.units.";
    private final String id;
    private final Version version;

    private ClusterStatusKey(String id, Version version) {
        this.id = id;
        this.version = version;
    }

    public ByteArray toByteArray() {
        return UnitKey.toByteArray(UNITS_PREFIX, this.id, this.version == null ? null : this.version.render());
    }

    public static ClusterStatusKey fromBytes(byte[] key) {
        String[] parse = UnitKey.fromBytes(UNITS_PREFIX, key);
        int length = parse.length;
        String id = length > 0 ? parse[0] : null;
        Version version = length > 1 ? Version.parseVersion(parse[1]) : null;
        return ClusterStatusKey.builder().id(id).version(version).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStatusKey that = (ClusterStatusKey)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public static ClusterStatusKeyBuilder builder() {
        return new ClusterStatusKeyBuilder();
    }

    public static class ClusterStatusKeyBuilder {
        private String id;
        private Version version;

        public ClusterStatusKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ClusterStatusKeyBuilder version(Version version) {
            this.version = version;
            return this;
        }

        public ClusterStatusKey build() {
            return new ClusterStatusKey(this.id, this.version);
        }
    }
}

