/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.UUID;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResultStatus;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class AbortResult {
    private static final AbortResult NO_WRITE_INTENT_ABORT_RESULT = new AbortResult(AbortResultStatus.NO_WRITE_INTENT, null, null);
    private final AbortResultStatus status;
    @Nullable
    private final UUID expectedTxId;
    @Nullable
    private final BinaryRow previousWriteIntent;

    private AbortResult(AbortResultStatus status, @Nullable UUID expectedTxId, @Nullable BinaryRow previousWriteIntent) {
        this.status = status;
        this.expectedTxId = expectedTxId;
        this.previousWriteIntent = previousWriteIntent;
    }

    public static AbortResult success(@Nullable BinaryRow previousUncommittedRowVersion) {
        return new AbortResult(AbortResultStatus.SUCCESS, null, previousUncommittedRowVersion);
    }

    public static AbortResult noWriteIntent() {
        return NO_WRITE_INTENT_ABORT_RESULT;
    }

    public static AbortResult txMismatch(UUID expectedTxId) {
        return new AbortResult(AbortResultStatus.TX_MISMATCH, expectedTxId, null);
    }

    public AbortResultStatus status() {
        return this.status;
    }

    @Nullable
    public UUID expectedTxId() {
        return this.expectedTxId;
    }

    @Nullable
    public BinaryRow previousWriteIntent() {
        return this.previousWriteIntent;
    }

    public String toString() {
        return S.toString(this);
    }
}

