/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.Map;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.table.AbstractClientStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.util.ColocationUtils;
import org.apache.ignite3.internal.util.HashCalculator;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.TupleHelper;

class KeyValueTupleStreamerPartitionAwarenessProvider
extends AbstractClientStreamerPartitionAwarenessProvider<Map.Entry<Tuple, Tuple>> {
    KeyValueTupleStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions) {
        super(schemaReg, partitions);
    }

    @Override
    int colocationHash(SchemaDescriptor schema, Map.Entry<Tuple, Tuple> item) {
        HashCalculator hashCalc = new HashCalculator();
        for (Column c : schema.colocationColumns()) {
            Object val = TupleHelper.valueOrDefault(item.getKey(), c.name(), null);
            ColocationUtils.append(hashCalc, val, c.type());
        }
        return hashCalc.hash();
    }
}

