/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.cache.CacheAffinityConfiguration;
import org.apache.ignite.internal.management.cache.CacheConfiguration;
import org.apache.ignite.internal.management.cache.CacheConfigurationCollectorTask;
import org.apache.ignite.internal.management.cache.CacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.management.cache.CacheEvictionConfiguration;
import org.apache.ignite.internal.management.cache.CacheInfo;
import org.apache.ignite.internal.management.cache.CacheListCommandArg;
import org.apache.ignite.internal.management.cache.CacheNearConfiguration;
import org.apache.ignite.internal.management.cache.CacheRebalanceConfiguration;
import org.apache.ignite.internal.management.cache.CacheStoreConfiguration;
import org.apache.ignite.internal.management.cache.QueryConfiguration;
import org.apache.ignite.internal.management.cache.ViewCacheCmd;
import org.apache.ignite.internal.management.cache.ViewCacheTask;
import org.apache.ignite.internal.management.cache.ViewCacheTaskResult;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class CacheListCommand
implements LocalCommand<CacheListCommandArg, ViewCacheTaskResult> {
    Function<CacheListCommandArg, Predicate<GridClientNode>> FILTER = arg -> node -> node.connectable() && (arg.nodeId() == null || Objects.equals(node.nodeId(), arg.nodeId()));

    @Override
    public String description() {
        return "Show information about caches, groups or sequences that match a regular expression. When executed without parameters, this subcommand prints the list of caches";
    }

    @Override
    public Class<CacheListCommandArg> argClass() {
        return CacheListCommandArg.class;
    }

    @Override
    public ViewCacheTaskResult execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, CacheListCommandArg arg, Consumer<String> printer) throws Exception {
        ViewCacheCmd cmd = arg.groups() ? ViewCacheCmd.GROUPS : (arg.seq() ? ViewCacheCmd.SEQ : ViewCacheCmd.CACHES);
        Optional<GridClientNode> node = CommandUtils.nodes(cli, client, ignite).stream().filter(this.FILTER.apply(arg)).findFirst();
        if (!node.isPresent()) {
            throw new IllegalArgumentException("Node not found: id=" + arg.nodeId());
        }
        ViewCacheTaskResult res = (ViewCacheTaskResult)CommandUtils.execute(cli, client, ignite, ViewCacheTask.class, arg, Collections.singletonList(node.get()));
        if (arg.config() && cmd == ViewCacheCmd.CACHES) {
            this.cachesConfig(cli, client, ignite, arg, res, printer);
        } else {
            this.printCacheInfos(res.cacheInfos(), cmd, printer);
        }
        return res;
    }

    private void cachesConfig(GridClient cli, IgniteClient client, Ignite ignite, CacheListCommandArg arg, ViewCacheTaskResult viewRes, Consumer<String> printer) throws Exception {
        Collection nodes = CommandUtils.nodes(cli, client, ignite).stream().filter(this.FILTER.apply(arg)).collect(Collectors.toSet());
        Map res = (Map)CommandUtils.execute(cli, client, ignite, CacheConfigurationCollectorTask.class, new CacheConfigurationCollectorTaskArg(arg.regex()), nodes);
        Map<String, Integer> cacheToMapped = viewRes.cacheInfos().stream().collect(Collectors.toMap(CacheInfo::getCacheName, CacheInfo::getMapped));
        this.printCachesConfig(res, OutputFormat.fromConsoleName(arg.outputFormat()), cacheToMapped, printer);
    }

    private void printCacheInfos(Collection<CacheInfo> infos, ViewCacheCmd cmd, Consumer<String> printer) {
        for (CacheInfo info : infos) {
            Map<String, Object> map = info.toMap(cmd);
            SB sb = new SB("[");
            for (Map.Entry<String, Object> e : map.entrySet()) {
                sb.a(e.getKey()).a("=").a(e.getValue()).a(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.a("]");
            printer.accept(sb.toString());
        }
    }

    private void printCachesConfig(Map<String, CacheConfiguration> caches, OutputFormat outputFormat, Map<String, Integer> cacheToMapped, Consumer<String> printer) {
        block3: for (Map.Entry<String, CacheConfiguration> entry : caches.entrySet()) {
            String cacheName = entry.getKey();
            switch (outputFormat) {
                case MULTI_LINE: {
                    Map<String, Object> params = CacheListCommand.mapToPairs(entry.getValue());
                    params.put("Mapped", cacheToMapped.get(cacheName));
                    printer.accept(String.format("[cache = '%s']", cacheName));
                    for (Map.Entry<String, Object> innerEntry : params.entrySet()) {
                        printer.accept(String.format("%s: %s", innerEntry.getKey(), innerEntry.getValue()));
                    }
                    printer.accept("");
                    continue block3;
                }
            }
            int mapped = cacheToMapped.get(cacheName);
            printer.accept(String.format("%s: %s %s=%s", entry.getKey(), this.toString(entry.getValue()), "mapped", mapped));
        }
    }

    private static Map<String, Object> mapToPairs(CacheConfiguration cfg) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        CacheAffinityConfiguration affCfg = cfg.getAffinityConfiguration();
        CacheNearConfiguration nearCfg = cfg.getNearConfiguration();
        CacheRebalanceConfiguration rebalanceCfg = cfg.getRebalanceConfiguration();
        CacheEvictionConfiguration evictCfg = cfg.getEvictionConfiguration();
        CacheStoreConfiguration storeCfg = cfg.getStoreConfiguration();
        QueryConfiguration qryCfg = cfg.getQueryConfiguration();
        params.put("Name", cfg.getName());
        params.put("Group", cfg.getGroupName());
        params.put("Dynamic Deployment ID", cfg.getDynamicDeploymentId());
        params.put("System", cfg.isSystem());
        params.put("Mode", (Object)cfg.getMode());
        params.put("Atomicity Mode", (Object)cfg.getAtomicityMode());
        params.put("Statistic Enabled", cfg.isStatisticsEnabled());
        params.put("Management Enabled", cfg.isManagementEnabled());
        params.put("On-heap cache enabled", cfg.isOnheapCacheEnabled());
        params.put("Partition Loss Policy", (Object)cfg.getPartitionLossPolicy());
        params.put("Query Parallelism", cfg.getQueryParallelism());
        params.put("Copy On Read", cfg.isCopyOnRead());
        params.put("Listener Configurations", cfg.getListenerConfigurations());
        params.put("Load Previous Value", cfg.isLoadPreviousValue());
        params.put("Memory Policy Name", cfg.getMemoryPolicyName());
        params.put("Node Filter", cfg.getNodeFilter());
        params.put("Read From Backup", cfg.isReadFromBackup());
        params.put("Topology Validator", cfg.getTopologyValidator());
        params.put("Time To Live Eager Flag", cfg.isEagerTtl());
        params.put("Write Synchronization Mode", (Object)cfg.getWriteSynchronizationMode());
        params.put("Invalidate", cfg.isInvalidate());
        params.put("Affinity Function", affCfg.getFunction());
        params.put("Affinity Backups", affCfg.getPartitionedBackups());
        params.put("Affinity Partitions", affCfg.getPartitions());
        params.put("Affinity Exclude Neighbors", affCfg.isExcludeNeighbors());
        params.put("Affinity Mapper", affCfg.getMapper());
        params.put("Rebalance Mode", (Object)rebalanceCfg.getMode());
        params.put("Rebalance Batch Size", rebalanceCfg.getBatchSize());
        params.put("Rebalance Timeout", rebalanceCfg.getTimeout());
        params.put("Rebalance Delay", rebalanceCfg.getPartitionedDelay());
        params.put("Time Between Rebalance Messages", rebalanceCfg.getThrottle());
        params.put("Rebalance Batches Count", rebalanceCfg.getBatchesPrefetchCnt());
        params.put("Rebalance Cache Order", rebalanceCfg.getRebalanceOrder());
        params.put("Eviction Policy Enabled", evictCfg.getPolicy() != null);
        params.put("Eviction Policy Factory", evictCfg.getPolicy());
        params.put("Eviction Policy Max Size", evictCfg.getPolicyMaxSize());
        params.put("Eviction Filter", evictCfg.getFilter());
        params.put("Near Cache Enabled", nearCfg.isNearEnabled());
        params.put("Near Start Size", nearCfg.getNearStartSize());
        params.put("Near Eviction Policy Factory", nearCfg.getNearEvictPolicy());
        params.put("Near Eviction Policy Max Size", nearCfg.getNearEvictMaxSize());
        params.put("Default Lock Timeout", cfg.getDefaultLockTimeout());
        params.put("Query Entities", cfg.getQueryEntities());
        params.put("Cache Interceptor", cfg.getInterceptor());
        params.put("Store Enabled", storeCfg.isEnabled());
        params.put("Store Class", storeCfg.getStore());
        params.put("Store Factory Class", storeCfg.getStoreFactory());
        params.put("Store Keep Binary", storeCfg.isStoreKeepBinary());
        params.put("Store Read Through", storeCfg.isReadThrough());
        params.put("Store Write Through", storeCfg.isWriteThrough());
        params.put("Store Write Coalescing", storeCfg.getWriteBehindCoalescing());
        params.put("Write-Behind Enabled", storeCfg.isWriteBehindEnabled());
        params.put("Write-Behind Flush Size", storeCfg.getFlushSize());
        params.put("Write-Behind Frequency", storeCfg.getFlushFrequency());
        params.put("Write-Behind Flush Threads Count", storeCfg.getFlushThreadCount());
        params.put("Write-Behind Batch Size", storeCfg.getBatchSize());
        params.put("Concurrent Asynchronous Operations Number", cfg.getMaxConcurrentAsyncOperations());
        params.put("Loader Factory Class Name", cfg.getLoaderFactory());
        params.put("Writer Factory Class Name", cfg.getWriterFactory());
        params.put("Expiry Policy Factory Class Name", cfg.getExpiryPolicyFactory());
        params.put("Query Execution Time Threshold", qryCfg.getLongQueryWarningTimeout());
        params.put("Query Escaped Names", qryCfg.isSqlEscapeAll());
        params.put("Query SQL Schema", qryCfg.getSqlSchema());
        params.put("Query SQL functions", qryCfg.getSqlFunctionClasses());
        params.put("Query Indexed Types", qryCfg.getIndexedTypes());
        params.put("Maximum payload size for offheap indexes", cfg.getSqlIndexMaxInlineSize());
        params.put("Query Metrics History Size", cfg.getQueryDetailMetricsSize());
        return params;
    }

    private String toString(CacheConfiguration cfg) {
        return cfg.toString().substring(cfg.getClass().getSimpleName().length() + 1);
    }

    public static enum OutputFormat {
        SINGLE_LINE("single-line"),
        MULTI_LINE("multi-line");

        private final String text;

        private OutputFormat(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }

        public static OutputFormat fromConsoleName(String text) {
            if (text == null) {
                return SINGLE_LINE;
            }
            for (OutputFormat format : OutputFormat.values()) {
                if (!format.text.equals(text)) continue;
                return format;
            }
            throw new IllegalArgumentException("Unknown output format " + text);
        }

        public String toString() {
            return this.text;
        }
    }
}

