/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log;

import java.io.Serializable;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.shade.guava32.com.google.common.primitives.Longs;
import org.apache.amoro.utils.FlipUtil;
import org.apache.iceberg.types.Type;

public interface LogData<T> {
    public static final byte[] MAGIC_NUMBER = new byte[]{110, 101, 116};

    default public String getVersion() {
        return new String(this.getVersionBytes());
    }

    public byte[] getVersionBytes();

    default public String getUpstreamId() {
        return new String(this.getUpstreamIdBytes());
    }

    public byte[] getUpstreamIdBytes();

    public long getEpicNo();

    default public byte[] getEpicNoBytes() {
        return Longs.toByteArray((long)this.getEpicNo());
    }

    public boolean getFlip();

    default public byte getFlipByte() {
        return FlipUtil.convertToByte((boolean)this.getFlip());
    }

    public ChangeAction getChangeAction();

    default public byte getChangeActionByte() {
        return this.getChangeAction().toByteValue();
    }

    public T getActualValue();

    public static interface Factory<T>
    extends Serializable {
        public T createActualValue(Object[] var1, Type[] var2);

        public LogData<T> create(T var1, Object ... var2);

        public Class<?> getActualValueClass();

        public Object convertIfNecessary(Type var1, Object var2);
    }

    public static interface FieldGetterFactory<T>
    extends Serializable {
        public FieldGetter<T> createFieldGetter(Type var1, int var2);
    }

    public static interface FieldGetter<T>
    extends Serializable {
        public Object getFieldOrNull(T var1, int var2);
    }
}

