/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Types;

public class ExpressionUtil {
    public static org.apache.iceberg.expressions.Expression convertPartitionDataToDataFilter(MixedTable table, int specId, Collection<StructLike> partitions) {
        False filter = Expressions.alwaysFalse();
        for (StructLike partition : partitions) {
            filter = Expressions.or((org.apache.iceberg.expressions.Expression)filter, (org.apache.iceberg.expressions.Expression)ExpressionUtil.convertPartitionDataToDataFilter(table, specId, partition));
        }
        return filter;
    }

    public static org.apache.iceberg.expressions.Expression convertPartitionDataToDataFilter(MixedTable table, int specId, StructLike partition) {
        PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById(table, specId);
        Schema schema = table.schema();
        True filter = Expressions.alwaysTrue();
        for (int i = 0; i < spec.fields().size(); ++i) {
            PartitionField partitionField = (PartitionField)spec.fields().get(i);
            Types.NestedField sourceField = schema.findField(partitionField.sourceId());
            UnboundTerm transform = Expressions.transform((String)sourceField.name(), (Transform)partitionField.transform());
            Class resultType = partitionField.transform().getResultType(sourceField.type()).typeId().javaClass();
            Object partitionValue = partition.get(i, resultType);
            filter = partitionValue != null ? Expressions.and((org.apache.iceberg.expressions.Expression)filter, (org.apache.iceberg.expressions.Expression)Expressions.equal((UnboundTerm)transform, (Object)partitionValue)) : Expressions.and((org.apache.iceberg.expressions.Expression)filter, (org.apache.iceberg.expressions.Expression)Expressions.isNull((UnboundTerm)transform));
        }
        return filter;
    }

    public static org.apache.iceberg.expressions.Expression convertSqlFilterToIcebergExpression(String sqlFilter, List<Types.NestedField> tableColumns) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)sqlFilter))) {
            return Expressions.alwaysTrue();
        }
        try {
            Select statement = (Select)CCJSqlParserUtil.parse((String)("SELECT * FROM dummy WHERE " + sqlFilter));
            PlainSelect select = statement.getPlainSelect();
            return ExpressionUtil.convertSparkExpressionToIceberg(select.getWhere(), tableColumns);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse where condition: " + sqlFilter, e);
        }
    }

    private static org.apache.iceberg.expressions.Expression convertSparkExpressionToIceberg(Expression whereExpr, List<Types.NestedField> tableColumns) {
        if (whereExpr instanceof IsNullExpression) {
            IsNullExpression isNull = (IsNullExpression)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(isNull.getLeftExpression(), tableColumns);
            return isNull.isNot() ? Expressions.notNull((String)column.name()) : Expressions.isNull((String)column.name());
        }
        if (whereExpr instanceof EqualsTo) {
            EqualsTo eq = (EqualsTo)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(eq.getLeftExpression(), tableColumns);
            return Expressions.equal((String)column.name(), (Object)ExpressionUtil.getValue(eq.getRightExpression(), column));
        }
        if (whereExpr instanceof NotEqualsTo) {
            NotEqualsTo ne = (NotEqualsTo)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(ne.getLeftExpression(), tableColumns);
            return Expressions.notEqual((String)column.name(), (Object)ExpressionUtil.getValue(ne.getRightExpression(), column));
        }
        if (whereExpr instanceof GreaterThan) {
            GreaterThan gt = (GreaterThan)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(gt.getLeftExpression(), tableColumns);
            return Expressions.greaterThan((String)column.name(), (Object)ExpressionUtil.getValue(gt.getRightExpression(), column));
        }
        if (whereExpr instanceof GreaterThanEquals) {
            GreaterThanEquals ge = (GreaterThanEquals)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(ge.getLeftExpression(), tableColumns);
            return Expressions.greaterThanOrEqual((String)column.name(), (Object)ExpressionUtil.getValue(ge.getRightExpression(), column));
        }
        if (whereExpr instanceof MinorThan) {
            MinorThan lt = (MinorThan)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(lt.getLeftExpression(), tableColumns);
            return Expressions.lessThan((String)column.name(), (Object)ExpressionUtil.getValue(lt.getRightExpression(), column));
        }
        if (whereExpr instanceof MinorThanEquals) {
            MinorThanEquals le = (MinorThanEquals)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(le.getLeftExpression(), tableColumns);
            return Expressions.lessThanOrEqual((String)column.name(), (Object)ExpressionUtil.getValue(le.getRightExpression(), column));
        }
        if (whereExpr instanceof InExpression) {
            InExpression in = (InExpression)whereExpr;
            Types.NestedField column = ExpressionUtil.getColumn(in.getLeftExpression(), tableColumns);
            Expression rightExpr = in.getRightExpression();
            ArrayList<Object> values = new ArrayList<Object>();
            if (rightExpr instanceof ExpressionList) {
                for (Expression expr : (ExpressionList)rightExpr) {
                    values.add(ExpressionUtil.getValue(expr, column));
                }
            } else {
                throw new UnsupportedOperationException("Subquery IN not supported");
            }
            return in.isNot() ? Expressions.notIn((String)column.name(), values) : Expressions.in((String)column.name(), values);
        }
        if (whereExpr instanceof NotExpression) {
            NotExpression not = (NotExpression)whereExpr;
            return Expressions.not((org.apache.iceberg.expressions.Expression)ExpressionUtil.convertSparkExpressionToIceberg(not.getExpression(), tableColumns));
        }
        if (whereExpr instanceof AndExpression) {
            AndExpression and = (AndExpression)whereExpr;
            return Expressions.and((org.apache.iceberg.expressions.Expression)ExpressionUtil.convertSparkExpressionToIceberg(and.getLeftExpression(), tableColumns), (org.apache.iceberg.expressions.Expression)ExpressionUtil.convertSparkExpressionToIceberg(and.getRightExpression(), tableColumns));
        }
        if (whereExpr instanceof OrExpression) {
            OrExpression or = (OrExpression)whereExpr;
            return Expressions.or((org.apache.iceberg.expressions.Expression)ExpressionUtil.convertSparkExpressionToIceberg(or.getLeftExpression(), tableColumns), (org.apache.iceberg.expressions.Expression)ExpressionUtil.convertSparkExpressionToIceberg(or.getRightExpression(), tableColumns));
        }
        throw new UnsupportedOperationException("Unsupported expression: " + whereExpr);
    }

    private static Types.NestedField getColumn(Expression expr, List<Types.NestedField> tableColumns) {
        if (expr instanceof Column) {
            String columnName = ((Column)expr).getColumnName();
            Optional<Types.NestedField> column = tableColumns.stream().filter(c -> c.name().equals(columnName)).findFirst();
            if (column.isPresent()) {
                return column.get();
            }
            throw new IllegalArgumentException("Column not found: " + columnName);
        }
        throw new IllegalArgumentException("Expected column reference, got: " + expr);
    }

    private static Object getValue(Expression expr, Types.NestedField column) {
        try {
            return ExpressionUtil.convertValue(expr, column);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert value: " + expr, e);
        }
    }

    private static Object convertValue(Expression expr, Types.NestedField column) {
        switch (column.type().typeId()) {
            case BOOLEAN: {
                return Boolean.valueOf(((Column)expr).getColumnName());
            }
            case STRING: {
                return ((StringValue)expr).getValue();
            }
            case INTEGER: 
            case LONG: {
                return ((LongValue)expr).getValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return ((DoubleValue)expr).getValue();
            }
            case DATE: {
                String dateStr = ExpressionUtil.getDateTimeLiteralStr(expr, "date");
                if (dateStr == null) break;
                return Date.valueOf(dateStr).toLocalDate().toEpochDay();
            }
            case TIME: {
                String timeStr = ExpressionUtil.getDateTimeLiteralStr(expr, "time");
                if (timeStr == null) break;
                return Time.valueOf(timeStr).toLocalTime().getLong(ChronoField.MICRO_OF_DAY);
            }
            case TIMESTAMP: {
                String timestampStr = ExpressionUtil.getDateTimeLiteralStr(expr, "timestamp");
                if (timestampStr == null) break;
                long timestamp = column.type().equals(Types.TimestampType.withZone()) ? OffsetDateTime.parse(timestampStr).toEpochSecond() : LocalDateTime.parse(timestampStr).toEpochSecond(ZoneOffset.ofHours(0));
                return timestamp * 1000000L;
            }
        }
        throw new IllegalArgumentException(expr + " can not be converted to column type: " + column.type());
    }

    private static String getDateTimeLiteralStr(Expression expr, String type) {
        String timestampStr = null;
        if (expr instanceof StringValue) {
            timestampStr = ((StringValue)expr).getValue();
        } else if (expr instanceof DateTimeLiteralExpression && ((DateTimeLiteralExpression)expr).getType().name().equalsIgnoreCase(type)) {
            timestampStr = ((DateTimeLiteralExpression)expr).getValue().replaceAll("^'(.*)'$", "$1");
        }
        return timestampStr;
    }
}

