/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogUtil.class);

    public static Set<TableFormat> tableFormats(CatalogMeta meta) {
        return CatalogUtil.tableFormats(meta.getCatalogType(), meta.getCatalogProperties());
    }

    public static Set<TableFormat> tableFormats(String metastoreType, Map<String, String> catalogProperties) {
        if (catalogProperties != null && catalogProperties.containsKey("table-formats")) {
            String tableFormatsProperty = catalogProperties.get("table-formats");
            return Arrays.stream(tableFormatsProperty.split(",")).map(tableFormatString -> TableFormat.valueOf(tableFormatString.trim().toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
        }
        switch (metastoreType) {
            case "ams": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.MIXED_ICEBERG});
            }
            case "custom": 
            case "hadoop": 
            case "glue": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG});
            }
            case "hive": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.MIXED_HIVE});
            }
        }
        throw new IllegalArgumentException("Unsupported catalog type:" + metastoreType);
    }

    public static void mergeCatalogProperties(CatalogMeta meta, Map<String, String> properties) {
        if (meta.getCatalogProperties() == null) {
            meta.setCatalogProperties(Maps.newHashMap());
        }
        if (properties != null) {
            properties.forEach(meta::putToCatalogProperties);
        }
    }

    public static Map<String, String> mergeCatalogPropertiesToTable(Map<String, String> tableProperties, Map<String, String> catalogProperties) {
        Map<String, String> mergedProperties = catalogProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("table.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("table.".length()), Map.Entry::getValue));
        mergedProperties.putAll(tableProperties);
        return mergedProperties;
    }

    public static TableMetaStore buildMetaStore(CatalogMeta catalogMeta) {
        String authType;
        boolean loadAuthFromAMS;
        Map<String, String> storageConfigs;
        TableMetaStore.Builder builder = TableMetaStore.builder();
        if (catalogMeta.getStorageConfigs() != null && "Hadoop".equalsIgnoreCase(CatalogUtil.getCompatibleStorageType(storageConfigs = catalogMeta.getStorageConfigs()))) {
            String coreSite = storageConfigs.get("hadoop.core.site");
            String hdfsSite = storageConfigs.get("hadoop.hdfs.site");
            String hiveSite = storageConfigs.get("hive.site");
            builder.withBase64CoreSite(coreSite).withBase64MetaStoreSite(hiveSite).withBase64HdfsSite(hdfsSite);
        }
        if ((loadAuthFromAMS = CatalogUtil.propertyAsBoolean(catalogMeta.getCatalogProperties(), "auth.load-from-ams", true)) && catalogMeta.getAuthConfigs() != null) {
            Map<String, String> authConfigs = catalogMeta.getAuthConfigs();
            String authType2 = authConfigs.get("auth.type");
            LOG.info("TableMetaStore use auth config in catalog meta, authType is {}", (Object)authType2);
            if ("simple".equalsIgnoreCase(authType2)) {
                String hadoopUsername = authConfigs.get("auth.simple.hadoop_username");
                builder.withSimpleAuth(hadoopUsername);
            } else if ("kerberos".equalsIgnoreCase(authType2)) {
                String krb5 = authConfigs.get("auth.kerberos.krb5");
                String keytab = authConfigs.get("auth.kerberos.keytab");
                String principal = authConfigs.get("auth.kerberos.principal");
                builder.withBase64KrbAuth(keytab, krb5, principal);
            } else if ("ak/sk".equalsIgnoreCase(authType2)) {
                String accessKey = authConfigs.get("auth.ak_sk.access_key");
                String secretKey = authConfigs.get("auth.ak_sk.secret_key");
                builder.withAkSkAuth(accessKey, secretKey);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(authType = catalogMeta.getCatalogProperties().get("auth.type")))) {
            LOG.info("TableMetaStore use auth config in properties, authType is {}", (Object)authType);
            if ("simple".equalsIgnoreCase(authType)) {
                String hadoopUsername = catalogMeta.getCatalogProperties().get("auth.simple.hadoop_username");
                builder.withSimpleAuth(hadoopUsername);
            } else if ("kerberos".equalsIgnoreCase(authType)) {
                String krb5 = catalogMeta.getCatalogProperties().get("auth.kerberos.krb5");
                String keytab = catalogMeta.getCatalogProperties().get("auth.kerberos.keytab");
                String principal = catalogMeta.getCatalogProperties().get("auth.kerberos.principal");
                builder.withBase64KrbAuth(keytab, krb5, principal);
            } else if ("ak/sk".equalsIgnoreCase(authType)) {
                String accessKey = catalogMeta.getCatalogProperties().get("auth.ak_sk.access_key");
                String secretKey = catalogMeta.getCatalogProperties().get("auth.ak_sk.secret_key");
                builder.withAkSkAuth(accessKey, secretKey);
            }
        }
        return builder.build();
    }

    public static TableIdentifier tableId(TableMeta tableMeta) {
        return TableIdentifier.of(tableMeta.getTableIdentifier().getCatalog(), tableMeta.getTableIdentifier().getDatabase(), tableMeta.getTableIdentifier().getTableName());
    }

    public static org.apache.amoro.api.TableIdentifier amsTableId(TableIdentifier tableIdentifier) {
        return new org.apache.amoro.api.TableIdentifier(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName());
    }

    public static String getCompatibleStorageType(Map<String, String> conf) {
        if ("hdfs".equals(conf.get("storage.type"))) {
            return "Hadoop";
        }
        return conf.get("storage.type");
    }

    public static <T> void copyProperty(Map<String, String> fromProperties, Map<String, T> toProperties, String fromKey, String toKey) {
        if (StringUtils.isNotEmpty((CharSequence)fromProperties.get(fromKey))) {
            toProperties.put(toKey, fromProperties.get(fromKey));
        }
    }

    private static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

