/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ByteLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ByteLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ByteLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

final class ImmutableByteLongHashMap
implements ImmutableByteLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteLongMap delegate;

    ImmutableByteLongHashMap(ByteLongMap delegate) {
        this.delegate = new ByteLongHashMap(delegate);
    }

    public long get(byte key) {
        return this.delegate.get(key);
    }

    public long getIfAbsent(byte key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ByteLongPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongByteMap flipUniqueValues() {
        MutableLongByteMap result = LongByteMaps.mutable.empty();
        this.forEachKeyValue((ByteLongProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableByteLongMap select(ByteLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteLongMap reject(ByteLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableLongIterator iterator = this.delegate.longIterator();
            while (iterator.hasNext()) {
                MutableLongBag batch = LongBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableByteLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.delegate.longIterator());
    }

    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongBag select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public long[] toArray(long[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableByteLongMap newWithKeyValue(byte key, long value) {
        ByteLongHashMap map = new ByteLongHashMap(this.size() + 1);
        map.putAll((ByteLongMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableByteLongMap newWithoutKey(byte key) {
        ByteLongHashMap map = new ByteLongHashMap(this.size());
        map.putAll((ByteLongMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableByteLongMap newWithoutAllKeys(ByteIterable keys) {
        ByteLongHashMap map = new ByteLongHashMap(this.size());
        map.putAll((ByteLongMap)this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteLongMapSerializationProxy((ByteLongMap)this);
    }

    protected static class ImmutableByteLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteLongMap map;

        public ImmutableByteLongMapSerializationProxy() {
        }

        protected ImmutableByteLongMapSerializationProxy(ByteLongMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ByteLongProcedure)new CheckedByteLongProcedure(){

                    @Override
                    public void safeValue(byte key, long value) throws IOException {
                        out.writeByte(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteLongHashMap deserializedMap = new ByteLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

