/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.TraversableOnceException;

@Internal
public class CopyingIterator<E>
implements Iterator<E>,
Iterable<E> {
    private final Iterator<E> source;
    private final TypeSerializer<E> serializer;
    private boolean available = true;

    public CopyingIterator(Iterator<E> source, TypeSerializer<E> serializer) {
        this.source = source;
        this.serializer = serializer;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.available) {
            this.available = false;
            return this;
        }
        throw new TraversableOnceException();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public E next() {
        E next = this.source.next();
        return this.serializer.copy(next);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

