/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.util.MdcUtils;
import org.apache.flink.util.Preconditions;

class MdcAwareExecutor<T extends Executor>
implements Executor {
    protected final Map<String, String> contextData;
    protected final T delegate;

    protected MdcAwareExecutor(T delegate, Map<String, String> contextData) {
        this.delegate = (Executor)Preconditions.checkNotNull(delegate);
        this.contextData = Collections.unmodifiableMap(Preconditions.checkNotNull(contextData));
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(MdcUtils.wrapRunnable(this.contextData, command));
    }
}

