/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ReadRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=629");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=631");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=630");
    private final RequestHeader requestHeader;
    private final Double maxAge;
    private final TimestampsToReturn timestampsToReturn;
    private final ReadValueId[] nodesToRead;

    public ReadRequest(RequestHeader requestHeader, Double maxAge, TimestampsToReturn timestampsToReturn, ReadValueId[] nodesToRead) {
        this.requestHeader = requestHeader;
        this.maxAge = maxAge;
        this.timestampsToReturn = timestampsToReturn;
        this.nodesToRead = nodesToRead;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Double getMaxAge() {
        return this.maxAge;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public ReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    protected ReadRequest(ReadRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((ReadRequestBuilder)b).requestHeader;
        this.maxAge = ((ReadRequestBuilder)b).maxAge;
        this.timestampsToReturn = ((ReadRequestBuilder)b).timestampsToReturn;
        this.nodesToRead = ((ReadRequestBuilder)b).nodesToRead;
    }

    public static ReadRequestBuilder<?, ?> builder() {
        return new ReadRequestBuilderImpl();
    }

    public ReadRequestBuilder<?, ?> toBuilder() {
        return new ReadRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadRequest)) {
            return false;
        }
        ReadRequest other = (ReadRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$maxAge = this.getMaxAge();
        Double other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        TimestampsToReturn this$timestampsToReturn = this.getTimestampsToReturn();
        TimestampsToReturn other$timestampsToReturn = other.getTimestampsToReturn();
        if (this$timestampsToReturn == null ? other$timestampsToReturn != null : !this$timestampsToReturn.equals(other$timestampsToReturn)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToRead(), other.getNodesToRead());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReadRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        TimestampsToReturn $timestampsToReturn = this.getTimestampsToReturn();
        result = result * 59 + ($timestampsToReturn == null ? 43 : $timestampsToReturn.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToRead());
        return result;
    }

    @Override
    public String toString() {
        return "ReadRequest(requestHeader=" + this.getRequestHeader() + ", maxAge=" + this.getMaxAge() + ", timestampsToReturn=" + this.getTimestampsToReturn() + ", nodesToRead=" + Arrays.deepToString(this.getNodesToRead()) + ")";
    }

    private static final class ReadRequestBuilderImpl
    extends ReadRequestBuilder<ReadRequest, ReadRequestBuilderImpl> {
        private ReadRequestBuilderImpl() {
        }

        @Override
        protected ReadRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ReadRequest build() {
            return new ReadRequest(this);
        }
    }

    public static abstract class ReadRequestBuilder<C extends ReadRequest, B extends ReadRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Double maxAge;
        private TimestampsToReturn timestampsToReturn;
        private ReadValueId[] nodesToRead;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadRequest instance, ReadRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.maxAge(instance.maxAge);
            b.timestampsToReturn(instance.timestampsToReturn);
            b.nodesToRead(instance.nodesToRead);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B maxAge(Double maxAge) {
            this.maxAge = maxAge;
            return (B)this.self();
        }

        public B timestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return (B)this.self();
        }

        public B nodesToRead(ReadValueId[] nodesToRead) {
            this.nodesToRead = nodesToRead;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadRequest.ReadRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", maxAge=" + this.maxAge + ", timestampsToReturn=" + this.timestampsToReturn + ", nodesToRead=" + Arrays.deepToString(this.nodesToRead) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadRequest> {
        @Override
        public Class<ReadRequest> getType() {
            return ReadRequest.class;
        }

        @Override
        public ReadRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Double maxAge = decoder.readDouble("MaxAge");
            TimestampsToReturn timestampsToReturn = decoder.readEnum("TimestampsToReturn", TimestampsToReturn.class);
            ReadValueId[] nodesToRead = (ReadValueId[])decoder.readStructArray("NodesToRead", ReadValueId.TYPE_ID);
            return new ReadRequest(requestHeader, maxAge, timestampsToReturn, nodesToRead);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeDouble("MaxAge", value.getMaxAge());
            encoder.writeEnum("TimestampsToReturn", value.getTimestampsToReturn());
            encoder.writeStructArray("NodesToRead", (Object[])value.getNodesToRead(), ReadValueId.TYPE_ID);
        }
    }
}

