/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryEventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class UpdateEventDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=683");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=685");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=684");
    private final PerformUpdateType performInsertReplace;
    private final EventFilter filter;
    private final HistoryEventFieldList[] eventData;

    public UpdateEventDetails(NodeId nodeId, PerformUpdateType performInsertReplace, EventFilter filter, HistoryEventFieldList[] eventData) {
        super(nodeId);
        this.performInsertReplace = performInsertReplace;
        this.filter = filter;
        this.eventData = eventData;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public PerformUpdateType getPerformInsertReplace() {
        return this.performInsertReplace;
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    public HistoryEventFieldList[] getEventData() {
        return this.eventData;
    }

    protected UpdateEventDetails(UpdateEventDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.performInsertReplace = ((UpdateEventDetailsBuilder)b).performInsertReplace;
        this.filter = ((UpdateEventDetailsBuilder)b).filter;
        this.eventData = ((UpdateEventDetailsBuilder)b).eventData;
    }

    public static UpdateEventDetailsBuilder<?, ?> builder() {
        return new UpdateEventDetailsBuilderImpl();
    }

    public UpdateEventDetailsBuilder<?, ?> toBuilder() {
        return new UpdateEventDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateEventDetails)) {
            return false;
        }
        UpdateEventDetails other = (UpdateEventDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PerformUpdateType this$performInsertReplace = this.getPerformInsertReplace();
        PerformUpdateType other$performInsertReplace = other.getPerformInsertReplace();
        if (this$performInsertReplace == null ? other$performInsertReplace != null : !this$performInsertReplace.equals(other$performInsertReplace)) {
            return false;
        }
        EventFilter this$filter = this.getFilter();
        EventFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        return Arrays.deepEquals(this.getEventData(), other.getEventData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateEventDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PerformUpdateType $performInsertReplace = this.getPerformInsertReplace();
        result = result * 59 + ($performInsertReplace == null ? 43 : $performInsertReplace.hashCode());
        EventFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEventData());
        return result;
    }

    @Override
    public String toString() {
        return "UpdateEventDetails(performInsertReplace=" + this.getPerformInsertReplace() + ", filter=" + this.getFilter() + ", eventData=" + Arrays.deepToString(this.getEventData()) + ")";
    }

    private static final class UpdateEventDetailsBuilderImpl
    extends UpdateEventDetailsBuilder<UpdateEventDetails, UpdateEventDetailsBuilderImpl> {
        private UpdateEventDetailsBuilderImpl() {
        }

        @Override
        protected UpdateEventDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public UpdateEventDetails build() {
            return new UpdateEventDetails(this);
        }
    }

    public static abstract class UpdateEventDetailsBuilder<C extends UpdateEventDetails, B extends UpdateEventDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private PerformUpdateType performInsertReplace;
        private EventFilter filter;
        private HistoryEventFieldList[] eventData;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UpdateEventDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UpdateEventDetails instance, UpdateEventDetailsBuilder<?, ?> b) {
            b.performInsertReplace(instance.performInsertReplace);
            b.filter(instance.filter);
            b.eventData(instance.eventData);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B performInsertReplace(PerformUpdateType performInsertReplace) {
            this.performInsertReplace = performInsertReplace;
            return (B)this.self();
        }

        public B filter(EventFilter filter) {
            this.filter = filter;
            return (B)this.self();
        }

        public B eventData(HistoryEventFieldList[] eventData) {
            this.eventData = eventData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UpdateEventDetails.UpdateEventDetailsBuilder(super=" + super.toString() + ", performInsertReplace=" + this.performInsertReplace + ", filter=" + this.filter + ", eventData=" + Arrays.deepToString(this.eventData) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UpdateEventDetails> {
        @Override
        public Class<UpdateEventDetails> getType() {
            return UpdateEventDetails.class;
        }

        @Override
        public UpdateEventDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            PerformUpdateType performInsertReplace = decoder.readEnum("PerformInsertReplace", PerformUpdateType.class);
            EventFilter filter = (EventFilter)decoder.readStruct("Filter", EventFilter.TYPE_ID);
            HistoryEventFieldList[] eventData = (HistoryEventFieldList[])decoder.readStructArray("EventData", HistoryEventFieldList.TYPE_ID);
            return new UpdateEventDetails(nodeId, performInsertReplace, filter, eventData);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UpdateEventDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("PerformInsertReplace", value.getPerformInsertReplace());
            encoder.writeStruct("Filter", (Object)value.getFilter(), EventFilter.TYPE_ID);
            encoder.writeStructArray("EventData", (Object[])value.getEventData(), HistoryEventFieldList.TYPE_ID);
        }
    }
}

