/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.BackBooleanTVList;
import org.apache.iotdb.db.utils.datastructure.QuickBooleanTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimBooleanTVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;

public abstract class BooleanTVList
extends TVList {
    protected List<boolean[]> values = new ArrayList<boolean[]>();

    BooleanTVList() {
    }

    public static BooleanTVList newList() {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickBooleanTVList();
            }
            case BACKWARD: {
                return new BackBooleanTVList();
            }
        }
        return new TimBooleanTVList();
    }

    @Override
    public synchronized BooleanTVList clone() {
        BooleanTVList cloneList = BooleanTVList.newList();
        this.cloneAs(cloneList);
        this.cloneBitMap(cloneList);
        for (boolean[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private boolean[] cloneValue(boolean[] array) {
        boolean[] cloneArray = new boolean[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public synchronized void putBoolean(long timestamp, boolean value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.maxTime = Math.max(this.maxTime, timestamp);
        this.minTime = Math.min(this.minTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        if (this.indices != null) {
            ((int[])this.indices.get((int)arrayIndex))[elementIndex] = this.rowCount;
        }
        ++this.rowCount;
        if (this.sorted) {
            if (this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
                this.sorted = false;
            } else {
                ++this.seqRowCount;
            }
        }
    }

    @Override
    public boolean getBoolean(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int valueIndex = this.getValueIndex(index);
        int arrayIndex = valueIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = valueIndex % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    @Override
    protected void clearValue() {
        if (this.values != null) {
            for (boolean[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    protected void expandValues() {
        if (this.indices != null) {
            this.indices.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
        }
        this.values.add((boolean[])this.getPrimitiveArraysByType(TSDataType.BOOLEAN));
        if (this.bitMap != null) {
            this.bitMap.add(null);
        }
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)this.getBoolean(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)this.getBoolean(index)));
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        for (int i = 0; i < this.rowCount; ++i) {
            if (this.isNullValue(this.getValueIndex(i)) || ModificationUtils.isPointDeleted(this.getTime(i), deletionList, deleteCursor) || i != this.rowCount - 1 && this.getTime(i) == this.getTime(i + 1)) continue;
            builder.getTimeColumnBuilder().writeLong(this.getTime(i));
            builder.getColumnBuilder(0).writeBoolean(this.getBoolean(i));
            builder.declarePosition();
        }
    }

    @Override
    public synchronized void putBooleans(long[] time, boolean[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            boolean[] clonedValue = new boolean[value.length];
            System.arraycopy(value, 0, clonedValue, 0, value.length);
            value = clonedValue;
            int nullCnt = this.dropNullValThenUpdateMinMaxTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMinMaxTimeAndSorted(time, start, end);
        }
        while (idx < end) {
            int[] indexes;
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                if (this.indices != null) {
                    indexes = IntStream.range(this.rowCount, this.rowCount + inputRemaining).toArray();
                    System.arraycopy(indexes, 0, this.indices.get(arrayIdx), elementIdx, inputRemaining);
                }
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            if (this.indices != null) {
                indexes = IntStream.range(this.rowCount, this.rowCount + internalRemaining).toArray();
                System.arraycopy(indexes, 0, this.indices.get(arrayIdx), elementIdx, internalRemaining);
            }
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMinMaxTimeAndSorted(long[] time, boolean[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        int inputSeqRowCount = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            this.maxTime = Math.max(this.maxTime, time[tIdx]);
            if (!inputSorted) continue;
            if (tIdx > 0 && time[tIdx - 1] > time[tIdx]) {
                inputSorted = false;
                continue;
            }
            ++inputSeqRowCount;
        }
        this.minTime = Math.min(this.minTime, inPutMinTime);
        if (this.sorted && (this.rowCount == 0 || end - start > nullCnt && time[start - tIdxOffset] >= this.getTime(this.rowCount - 1))) {
            this.seqRowCount += inputSeqRowCount;
        }
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    public int serializedSize() {
        return 5 + this.rowCount * 10;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.BOOLEAN, buffer);
        buffer.putInt(this.rowCount);
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            buffer.putLong(this.getTime(rowIdx));
            WALWriteUtils.write(this.getBoolean(rowIdx), buffer);
            WALWriteUtils.write(this.isNullValue(this.getValueIndex(rowIdx)), buffer);
        }
    }

    public static BooleanTVList deserialize(DataInputStream stream) throws IOException {
        BooleanTVList tvList = BooleanTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        boolean[] values = new boolean[rowCount];
        BitMap bitMap = new BitMap(rowCount);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = ReadWriteIOUtils.readBool((InputStream)stream);
            if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
            bitMap.mark(rowIdx);
        }
        tvList.putBooleans(times, values, bitMap, 0, rowCount);
        return tvList;
    }

    public static BooleanTVList deserializeWithoutBitMap(DataInputStream stream) throws IOException {
        BooleanTVList tvList = BooleanTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        boolean[] values = new boolean[rowCount];
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = ReadWriteIOUtils.readBool((InputStream)stream);
        }
        tvList.putBooleans(times, values, null, 0, rowCount);
        return tvList;
    }
}

