/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util;

import org.apache.jsieve.NumberArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.parser.generated.ASTargument;
import org.apache.jsieve.parser.generated.ASTarguments;
import org.apache.jsieve.parser.generated.ASTblock;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTcommands;
import org.apache.jsieve.parser.generated.ASTstart;
import org.apache.jsieve.parser.generated.ASTstring;
import org.apache.jsieve.parser.generated.ASTstring_list;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.ASTtest_list;
import org.apache.jsieve.parser.generated.SimpleNode;
import org.apache.jsieve.util.HaltTraversalException;
import org.apache.jsieve.util.NodeHandler;
import org.apache.jsieve.util.SieveHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeToSieveAdapter
implements NodeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeToSieveAdapter.class);
    private final SieveHandler handler;

    public NodeToSieveAdapter(SieveHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Handler must not be null");
        }
        this.handler = handler;
    }

    @Override
    public void start() throws HaltTraversalException {
    }

    @Override
    public void end() throws HaltTraversalException {
    }

    @Override
    public void end(SimpleNode node) throws HaltTraversalException {
    }

    @Override
    public void end(ASTstart node) throws HaltTraversalException {
        this.handler.endScript();
    }

    @Override
    public void end(ASTcommands node) throws HaltTraversalException {
        this.handler.endCommands();
    }

    @Override
    public void end(ASTcommand node) throws HaltTraversalException {
        this.handler.endCommand(node.getName());
    }

    @Override
    public void end(ASTblock node) throws HaltTraversalException {
        this.handler.endBlock();
    }

    @Override
    public void end(ASTarguments node) throws HaltTraversalException {
        this.handler.endArguments();
    }

    @Override
    public void end(ASTargument node) throws HaltTraversalException {
    }

    @Override
    public void end(ASTtest node) throws HaltTraversalException {
        String name = node.getName();
        this.handler.endTest(name);
    }

    @Override
    public void end(ASTtest_list node) throws HaltTraversalException {
        this.handler.endTestList();
    }

    @Override
    public void end(ASTstring node) throws HaltTraversalException {
    }

    @Override
    public void end(ASTstring_list node) throws HaltTraversalException {
        this.handler.endStringListArgument();
    }

    @Override
    public void start(SimpleNode node) throws HaltTraversalException {
    }

    @Override
    public void start(ASTstart node) throws HaltTraversalException {
        this.handler.startScript();
    }

    @Override
    public void start(ASTcommands node) throws HaltTraversalException {
        this.handler.startCommands();
    }

    @Override
    public void start(ASTcommand node) throws HaltTraversalException {
        this.handler.startCommand(node.getName());
    }

    @Override
    public void start(ASTblock node) throws HaltTraversalException {
        this.handler.startBlock();
    }

    @Override
    public void start(ASTarguments node) throws HaltTraversalException {
        this.handler.startArguments();
    }

    @Override
    public void start(ASTargument node) throws HaltTraversalException {
        Object value = node.getValue();
        if (value == null) {
            LOGGER.debug("Ignoring null argument");
        } else if (value instanceof NumberArgument) {
            NumberArgument numberArgument = (NumberArgument)value;
            Integer integer = numberArgument.getInteger();
            if (integer == null) {
                LOGGER.debug("Ignoring null numeric argument");
            } else {
                this.handler.argument(integer);
            }
        } else if (value instanceof TagArgument) {
            TagArgument tagArgument = (TagArgument)value;
            String tag = tagArgument.getTag();
            String identifier = tag.charAt(0) == ':' ? tag.substring(1) : tag;
            this.handler.argument(identifier);
        }
    }

    @Override
    public void start(ASTtest node) throws HaltTraversalException {
        String name = node.getName();
        this.handler.startTest(name);
    }

    @Override
    public void start(ASTtest_list node) throws HaltTraversalException {
        this.handler.startTestList();
    }

    @Override
    public void start(ASTstring node) throws HaltTraversalException {
        String string = (String)node.getValue();
        this.handler.listMember(string);
    }

    @Override
    public void start(ASTstring_list node) throws HaltTraversalException {
        this.handler.startStringListArgument();
    }
}

