/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.Closeable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetAnnotationRequest;
import org.apache.james.imap.message.response.AnnotationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnnotationProcessor
extends AbstractMailboxProcessor<GetAnnotationRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetAnnotationProcessor.class);

    public GetAnnotationProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(GetAnnotationRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return ImmutableList.of((Object)ImapConstants.SUPPORTS_ANNOTATION);
    }

    @Override
    protected void processRequest(GetAnnotationRequest request, ImapSession session, ImapProcessor.Responder responder) {
        try {
            this.proceed(request, session, responder);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.info("The command: {} is failed because not found mailbox {}", (Object)request.getCommand().getName(), (Object)request.getMailboxName());
            this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
        }
        catch (MailboxException e) {
            LOGGER.error("GetAnnotation on mailbox {} failed for user {}", new Object[]{request.getMailboxName(), session.getUserName(), e});
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void proceed(GetAnnotationRequest message, ImapSession session, ImapProcessor.Responder responder) throws MailboxException {
        String mailboxName = message.getMailboxName();
        Optional<Integer> maxsize = message.getMaxsize();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        List<MailboxAnnotation> mailboxAnnotations = this.getMailboxAnnotations(session, message.getKeys(), message.getDepth(), mailboxPath);
        Optional<Integer> maximumOversizedSize = this.getMaxSizeValue(mailboxAnnotations, maxsize);
        this.respond(message, responder, mailboxName, mailboxAnnotations, maxsize, maximumOversizedSize);
    }

    private void respond(ImapRequest request, ImapProcessor.Responder responder, String mailboxName, List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize, Optional<Integer> maximumOversizedSize) {
        if (maximumOversizedSize.isPresent()) {
            responder.respond(new AnnotationResponse(mailboxName, this.filterItemsBySize(mailboxAnnotations, maxsize)));
            this.okComplete(request, StatusResponse.ResponseCode.longestMetadataEntry(maximumOversizedSize.get().intValue()), responder);
        } else {
            responder.respond(new AnnotationResponse(mailboxName, mailboxAnnotations));
            this.okComplete(request, responder);
        }
    }

    private Optional<Integer> getMaxSizeValue(List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize) {
        if (maxsize.isPresent()) {
            return maxsize.map(value -> this.getMaxSizeOfOversizedItems(mailboxAnnotations, (Integer)value)).get();
        }
        return Optional.empty();
    }

    private List<MailboxAnnotation> filterItemsBySize(List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize) {
        Predicate<MailboxAnnotation> lowerPredicate = annotation -> maxsize.map(maxSizeInput -> annotation.size() <= maxSizeInput).orElse(true);
        return (List)mailboxAnnotations.stream().filter(lowerPredicate).collect(ImmutableList.toImmutableList());
    }

    private List<MailboxAnnotation> getMailboxAnnotations(ImapSession session, Set<MailboxAnnotationKey> keys, GetAnnotationRequest.Depth depth, MailboxPath mailboxPath) throws MailboxException {
        MailboxSession mailboxSession = session.getMailboxSession();
        switch (depth) {
            case ZERO: {
                return this.getMailboxAnnotationsWithDepthZero(keys, mailboxPath, mailboxSession);
            }
            case ONE: {
                return this.getMailboxManager().getAnnotationsByKeysWithOneDepth(mailboxPath, mailboxSession, keys);
            }
            case INFINITY: {
                return this.getMailboxManager().getAnnotationsByKeysWithAllDepth(mailboxPath, mailboxSession, keys);
            }
        }
        throw new NotImplementedException("Not implemented");
    }

    private List<MailboxAnnotation> getMailboxAnnotationsWithDepthZero(Set<MailboxAnnotationKey> keys, MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        if (keys.isEmpty()) {
            return this.getMailboxManager().getAllAnnotations(mailboxPath, mailboxSession);
        }
        return this.getMailboxManager().getAnnotationsByKeys(mailboxPath, mailboxSession, keys);
    }

    private Optional<Integer> getMaxSizeOfOversizedItems(List<MailboxAnnotation> mailboxAnnotations, Integer maxsize) {
        Predicate<MailboxAnnotation> filterOverSizedAnnotation = annotation -> annotation.size() > maxsize;
        ImmutableSortedSet overLimitSizes = (ImmutableSortedSet)mailboxAnnotations.stream().filter(filterOverSizedAnnotation).map(MailboxAnnotation::size).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.reverseOrder()));
        if (overLimitSizes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Integer)overLimitSizes.first());
    }

    @Override
    protected Closeable addContextToMDC(GetAnnotationRequest request) {
        return MDCBuilder.create().addToContext("action", "GET_ANNOTATION").addToContext("mailbox", request.getMailboxName()).addToContext("depth", request.getDepth().getCode()).addToContextIfPresent("maxSize", request.getMaxsize().map(i -> Integer.toString(i))).addToContext("keys", request.getKeys().toString()).build();
    }
}

