/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConfiguration {
    public static final String SEARCH_CONFIGURATION_NAME = "search";
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchConfiguration.class);
    private final Implementation implementation;

    public static SearchConfiguration parse(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(SEARCH_CONFIGURATION_NAME);
            return SearchConfiguration.from(configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Could not find {} configuration file, enabling elasticsearch by default", (Object)SEARCH_CONFIGURATION_NAME);
            return SearchConfiguration.elasticSearch();
        }
    }

    static SearchConfiguration from(Configuration configuration) throws ConfigurationException {
        String searchOption = configuration.getString("implementation", Implementation.ElasticSearch.name());
        if (searchOption.equalsIgnoreCase(Implementation.ElasticSearch.name())) {
            return SearchConfiguration.elasticSearch();
        }
        if (searchOption.equalsIgnoreCase(Implementation.Scanning.name())) {
            return SearchConfiguration.scanning();
        }
        throw new ConfigurationException(String.format("'implementation' parameter in '%s.properties' should have '%s' or '%s' value", SEARCH_CONFIGURATION_NAME, Implementation.ElasticSearch.name(), Implementation.Scanning.name()));
    }

    public static SearchConfiguration scanning() {
        return new SearchConfiguration(Implementation.Scanning);
    }

    public static SearchConfiguration elasticSearch() {
        return new SearchConfiguration(Implementation.ElasticSearch);
    }

    public SearchConfiguration(Implementation implementation) {
        this.implementation = implementation;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public static enum Implementation {
        Scanning,
        ElasticSearch;

    }
}

