/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;

public class JPAUidProvider
implements UidProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAUidProvider(EntityManagerFactory factory) {
        this.factory = factory;
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            long uid = (Long)manager.createNamedQuery("findLastUid").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            if (uid == 0L) {
                Optional<MessageUid> optional = Optional.empty();
                return optional;
            }
            Optional<MessageUid> optional = Optional.of(MessageUid.of((long)uid));
            return optional;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Unable to get last uid for mailbox " + mailbox, (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.nextUid((JPAId)mailbox.getMailboxId());
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        return this.nextUid((JPAId)mailboxId);
    }

    private MessageUid nextUid(JPAId mailboxId) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long uid = m.consumeUid();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            MessageUid messageUid = MessageUid.of((long)uid);
            return messageUid;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to save next uid for mailbox " + mailboxId.serialize(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }
}

