/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.CanNotCalculateChangesException;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$CannotCalculateChanges$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.EmailChangesRequest;
import org.apache.james.jmap.mail.EmailChangesResponse;
import org.apache.james.jmap.mail.HasMoreChanges$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\t\u0013\u0001uA\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00111\u0003!Q1A\u0005\u00025C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0011g\u0011\u0019Y\b\u0001)A\u0005O\"9A\u0010\u0001b\u0001\n\u0003j\bbBA\u000e\u0001\u0001\u0006IA \u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u001b\u0001\t\u0003\nYG\u0001\nF[\u0006LGn\u00115b]\u001e,7/T3uQ>$'BA\n\u0015\u0003\u0019iW\r\u001e5pI*\u0011QCF\u0001\u0005U6\f\u0007O\u0003\u0002\u00181\u0005)!.Y7fg*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0019QE\n\u0015\u000e\u0003II!a\n\n\u000315+G\u000f[8e%\u0016\fX/\u001b:j]\u001e\f5mY8v]RLE\r\u0005\u0002*Y5\t!F\u0003\u0002,)\u0005!Q.Y5m\u0013\ti#FA\nF[\u0006LGn\u00115b]\u001e,7OU3rk\u0016\u001cH/A\u0007nKR\u0014\u0018n\u0019$bGR|'/_\u000b\u0002aA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0004CBL'BA\u001b\u0017\u0003\u001diW\r\u001e:jGNL!a\u000e\u001a\u0003\u001b5+GO]5d\r\u0006\u001cGo\u001c:z\u00039iW\r\u001e:jG\u001a\u000b7\r^8ss\u0002\nQ#Z7bS2\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u00180F\u0001<!\ta\u0004)D\u0001>\u0015\tqt(\u0001\u0004dQ\u0006tw-\u001a\u0006\u0003gQI!!Q\u001f\u0003+\u0015k\u0017-\u001b7DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ss\u00061R-\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0015\u0003\u0019\u0011x.\u001e;fg&\u0011!j\u0012\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E#\u0012\u0001B2pe\u0016L!a\u0015)\u0003#M+7o]5p]R\u0013\u0018M\\:mCR|'/\u0001\ntKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J\u0004\u0013A\u0002\u001fj]&$h\bF\u0003X1fS6\f\u0005\u0002&\u0001!)a&\u0003a\u0001a!)\u0011(\u0003a\u0001w!)1)\u0003a\u0001\u000b\")A*\u0003a\u0001\u001d\"\u0012\u0011\"\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fa!\u001b8kK\u000e$(\"\u00012\u0002\u000b)\fg/\u0019=\n\u0005\u0011|&AB%oU\u0016\u001cG/\u0001\u0006nKRDw\u000e\u001a(b[\u0016,\u0012a\u001a\t\u0003Qbt!!\u001b<\u000f\u0005),hBA6u\u001d\ta7O\u0004\u0002ne:\u0011a.]\u0007\u0002_*\u0011\u0001\u000fH\u0001\u0007yI|w\u000e\u001e \n\u0003mI!!\u0007\u000e\n\u0005]A\u0012BA\u000b\u0017\u0013\t\tF#\u0003\u0002x!\u0006Q\u0011J\u001c<pG\u0006$\u0018n\u001c8\n\u0005eT(AC'fi\"|GMT1nK*\u0011q\u000fU\u0001\f[\u0016$\bn\u001c3OC6,\u0007%\u0001\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm]\u000b\u0002}B)q0a\u0002\u0002\u000e9!\u0011\u0011AA\u0002!\tq\u0007%C\u0002\u0002\u0006\u0001\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u00111aU3u\u0015\r\t)\u0001\t\t\u0005\u0003\u001f\t)BD\u0002j\u0003#I1!a\u0005Q\u0003Q\u0019\u0015\r]1cS2LG/_%eK:$\u0018NZ5fe&!\u0011qCA\r\u0005Q\u0019\u0015\r]1cS2LG/_%eK:$\u0018NZ5fe*\u0019\u00111\u0003)\u0002+I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3tA\u0005IAm\u001c)s_\u000e,7o\u001d\u000b\u000b\u0003C\tY$a\u0010\u0002D\u0005M\u0003CBA\u0012\u0003c\t)$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%\u0001XO\u00197jg\",'OC\u0002\"\u0003WQ1!UA\u0017\u0015\t\ty#A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005M\u0012Q\u0005\u0002\u0006'6{gn\u001c\t\u0004K\u0005]\u0012bAA\u001d%\t)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bBBA\u001f\u001d\u0001\u0007a0\u0001\u0007dCB\f'-\u001b7ji&,7\u000fC\u0004\u0002B9\u0001\r!!\u000e\u0002\u0015%tgo\\2bi&|g\u000eC\u0004\u0002F9\u0001\r!a\u0012\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002NY\tq!\\1jY\n|\u00070\u0003\u0003\u0002R\u0005-#AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0007\u0003+r\u0001\u0019\u0001\u0015\u0002\u000fI,\u0017/^3ti\u0006y!/\u001a;sS\u00164Xm\u00115b]\u001e,7\u000f\u0006\u0005\u0002\\\u0005\r\u0014QMA4!\u0019\t\u0019#!\r\u0002^A\u0019A(a\u0018\n\u0007\u0005\u0005TH\u0001\u0007F[\u0006LGn\u00115b]\u001e,7\u000f\u0003\u0004\u0002>=\u0001\rA \u0005\b\u0003\u000bz\u0001\u0019AA$\u0011\u0019\t)f\u0004a\u0001Q\u0005Qq-\u001a;SKF,Xm\u001d;\u0015\r\u00055\u0014QQAD!\u001d\ty'!\u001f\u0002\u0000!rA!!\u001d\u0002v9\u0019a.a\u001d\n\u0003\u0005J1!a\u001e!\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\t1Q)\u001b;iKJT1!a\u001e!!\u0011\ty'!!\n\t\u0005\r\u0015Q\u0010\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBA#!\u0001\u0007\u0011q\t\u0005\b\u0003\u0003\u0002\u0002\u0019AAE!\ry\u00151R\u0005\u0004\u0003\u001b\u0003&AC%om>\u001c\u0017\r^5p]\u0002")
public class EmailChangesMethod
implements MethodRequiringAccountId<EmailChangesRequest> {
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailChangesRequest request) {
        return this.retrieveChanges(capabilities, mailboxSession, request).map((Function1 & Serializable)emailChanges -> new EmailChangesResponse(request.accountId(), request.sinceState(), UuidState$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), HasMoreChanges$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getCreated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getUpdated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getDestroyed()).asScala().toSet())).map((Function1 & Serializable)response -> new InvocationWithContext(new Invocation(this.methodName(), EmailGetSerializer$.MODULE$.serializeChanges((EmailChangesResponse)response), invocation.invocation().methodCallId()), invocation.processingContext())).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof CanNotCalculateChangesException) {
                CanNotCalculateChangesException canNotCalculateChangesException = (CanNotCalculateChangesException)throwable;
                return SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, canNotCalculateChangesException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext()));
            }
            return SMono$.MODULE$.error(throwable);
        });
    }

    private SMono<EmailChanges> retrieveChanges(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, EmailChangesRequest request) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceStateWithDelegation(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges()))));
        }
        return SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceState(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges()))));
    }

    @Override
    public Either<IllegalArgumentException, EmailChangesRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return EmailGetSerializer$.MODULE$.deserializeEmailChangesRequest((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> ResponseSerializer$.MODULE$.asException((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
    }

    @Inject
    public EmailChangesMethod(MetricFactory metricFactory, EmailChangeRepository emailChangeRepository, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.metricFactory = metricFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/changes")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

