/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionIdGenerator;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.ForbiddenDelegationException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.store.RandomMailboxSessionIdGenerator;

public class SessionProviderImpl
implements SessionProvider {
    private final MailboxSessionIdGenerator idGenerator = new RandomMailboxSessionIdGenerator();
    private final Authenticator authenticator;
    private final Authorizator authorizator;

    @Inject
    public SessionProviderImpl(Authenticator authenticator, Authorizator authorizator) {
        this.authenticator = authenticator;
        this.authorizator = authorizator;
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.createSession(userName, Optional.empty(), MailboxSession.SessionType.System);
    }

    public SessionProvider.AuthorizationStep authenticate(final Username thisUserId, final String passwd) {
        return new SessionProvider.AuthorizationStep(){

            public MailboxSession as(Username otherUserId) throws MailboxException {
                if (!SessionProviderImpl.this.isValidLogin(thisUserId, passwd)) {
                    throw new BadCredentialsException();
                }
                return SessionProviderImpl.this.authenticate(thisUserId).as(otherUserId);
            }

            public MailboxSession withoutDelegation() throws MailboxException {
                if (SessionProviderImpl.this.isValidLogin(thisUserId, passwd)) {
                    return SessionProviderImpl.this.createSession(thisUserId, Optional.ofNullable(thisUserId), MailboxSession.SessionType.User);
                }
                throw new BadCredentialsException();
            }

            public MailboxSession forMatchingUser(Predicate<Username> otherPredicate) throws MailboxException {
                return (MailboxSession)SessionProviderImpl.this.authorizator.delegatedUsers(thisUserId).stream().filter(otherPredicate).findFirst().map(Throwing.function(otherUserId -> {
                    if (!SessionProviderImpl.this.isValidLogin(thisUserId, passwd)) {
                        throw new BadCredentialsException();
                    }
                    return SessionProviderImpl.this.createSession((Username)otherUserId, Optional.of(thisUserId), MailboxSession.SessionType.System);
                }).sneakyThrow()).orElseThrow(() -> new ForbiddenDelegationException(thisUserId));
            }
        };
    }

    public SessionProvider.AuthorizationStep authenticate(final Username givenUserid) {
        return new SessionProvider.AuthorizationStep(){

            public MailboxSession as(Username otherUserId) throws MailboxException {
                Authorizator.AuthorizationState authorizationState = SessionProviderImpl.this.authorizator.user(givenUserid).canLoginAs(otherUserId);
                switch (authorizationState) {
                    case ALLOWED: {
                        return SessionProviderImpl.this.createSession(otherUserId, Optional.of(givenUserid), MailboxSession.SessionType.System);
                    }
                    case FORBIDDEN: {
                        throw new ForbiddenDelegationException(givenUserid, otherUserId);
                    }
                    case UNKNOWN_USER: {
                        throw new UserDoesNotExistException(otherUserId);
                    }
                }
                throw new RuntimeException("Unknown AuthorizationState " + authorizationState);
            }

            public MailboxSession withoutDelegation() {
                return SessionProviderImpl.this.createSession(givenUserid, Optional.of(givenUserid), MailboxSession.SessionType.System);
            }

            public MailboxSession forMatchingUser(Predicate<Username> otherPredicate) throws MailboxException {
                return SessionProviderImpl.this.authorizator.delegatedUsers(givenUserid).stream().filter(otherPredicate).findFirst().map(otherUserId -> SessionProviderImpl.this.createSession((Username)otherUserId, Optional.of(givenUserid), MailboxSession.SessionType.System)).orElseThrow(() -> new ForbiddenDelegationException(givenUserid));
            }
        };
    }

    private MailboxSession createSession(Username userName, Optional<Username> loggedInUser, MailboxSession.SessionType type) {
        return new MailboxSession(this.newSessionId(), userName, loggedInUser, new ArrayList(), '.', type);
    }

    private MailboxSession.SessionId newSessionId() {
        return MailboxSession.SessionId.of((long)this.randomId());
    }

    private long randomId() {
        return this.idGenerator.nextId();
    }

    private boolean isValidLogin(Username userid, String passwd) throws MailboxException {
        return this.authenticator.isAuthentic(userid, (CharSequence)passwd);
    }
}

