/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.util.DurationParser;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;

public class Requeue
extends GenericMailet {
    private final MailQueueFactory<?> mailQueueFactory;
    private MailQueue mailQueue;
    private Optional<Duration> delayDuration;
    private ProcessingState processor;
    private boolean consume;

    @Inject
    public Requeue(MailQueueFactory<?> mailQueueFactory) {
        this.mailQueueFactory = mailQueueFactory;
    }

    public void init() throws MessagingException {
        MailQueueName mailQueueName = Optional.ofNullable(this.getInitParameter("queue")).map(MailQueueName::of).orElse(MailQueueFactory.SPOOL);
        this.mailQueue = this.mailQueueFactory.createQueue(mailQueueName);
        this.delayDuration = Optional.ofNullable(this.getInitParameter("delay")).map(delayValue -> DurationParser.parse((String)delayValue, (ChronoUnit)ChronoUnit.SECONDS));
        this.processor = Optional.ofNullable(this.getInitParameter("processor")).map(ProcessingState::new).orElse(new ProcessingState("root"));
        this.consume = this.getInitParameter("consume", true);
        Preconditions.checkArgument((this.delayDuration.isEmpty() || !this.delayDuration.get().isNegative() ? 1 : 0) != 0, (Object)"Duration should be non-negative");
    }

    public void destroy() {
        try {
            this.mailQueue.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (this.consume) {
            this.enqueue(mail);
            mail.setState("ghost");
        } else {
            Mail newMail = null;
            try {
                newMail = mail.duplicate();
                this.enqueue(newMail);
            }
            finally {
                LifecycleUtil.dispose((Object)newMail);
            }
        }
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)this.processor);
    }

    private void enqueue(Mail mail) {
        mail.setState(this.processor.getValue());
        this.delayDuration.ifPresentOrElse((Consumer<Duration>)Throwing.consumer(delay -> this.mailQueue.enQueue(mail, delay)), Throwing.runnable(() -> this.mailQueue.enQueue(mail)).sneakyThrow());
    }
}

