/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentMessageIdTable;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentOwnerTable;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentV2Table;

public interface CassandraAttachmentModule {
    public static final CassandraModule MODULE = CassandraModule.table((String)"attachmentV2").comment("Holds attachment for fast attachment retrieval. Content of messages is storedin `blobs` and `blobparts` tables.").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.sizeTieredCompactionStrategy())).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraAttachmentV2Table.ID_AS_UUID, DataTypes.UUID).withColumn(CassandraAttachmentV2Table.ID, DataTypes.TEXT).withColumn(CassandraAttachmentV2Table.BLOB_ID, DataTypes.TEXT).withColumn(CassandraAttachmentV2Table.TYPE, DataTypes.TEXT).withColumn(CassandraAttachmentV2Table.MESSAGE_ID, DataTypes.TIMEUUID).withColumn(CassandraAttachmentV2Table.SIZE, DataTypes.BIGINT)).table("attachmentMessageId").comment("Holds ids of messages owning the attachment").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.sizeTieredCompactionStrategy())).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID, DataTypes.UUID).withColumn(CassandraAttachmentMessageIdTable.ATTACHMENT_ID, DataTypes.TEXT).withClusteringColumn(CassandraAttachmentMessageIdTable.MESSAGE_ID, DataTypes.TEXT)).table("attachmentOwners").comment("Holds explicit owners of some attachments").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.leveledCompactionStrategy())).withBloomFilterFpChance(0.01)).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraAttachmentOwnerTable.ID, DataTypes.UUID).withClusteringColumn(CassandraAttachmentOwnerTable.OWNER, DataTypes.TEXT)).build();
}

