/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxPathV3Table;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxTable;

public interface CassandraMailboxModule {
    public static final CassandraModule MODULE = CassandraModule.builder().type(CassandraMailboxTable.MAILBOX_BASE.asCql(true)).statement(statement -> statement.withField(CassandraMailboxTable.MailboxBase.NAMESPACE, DataTypes.TEXT).withField(CassandraMailboxTable.MailboxBase.USER, DataTypes.TEXT)).table("mailbox").comment("Holds the mailboxes information.").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).withLZ4Compression(8, 1.0)).statement(statement -> types -> statement.withPartitionKey(CassandraMailboxTable.ID, DataTypes.TIMEUUID).withColumn(CassandraMailboxTable.MAILBOX_BASE, (DataType)types.getDefinedUserType(CassandraMailboxTable.MAILBOX_BASE.asCql(true))).withColumn(CassandraMailboxTable.NAME, DataTypes.TEXT).withColumn(CassandraMailboxTable.UIDVALIDITY, DataTypes.BIGINT)).table("mailboxPathV3").comment("Denormalisation table. Allow to retrieve mailboxes belonging to a certain user. This is a LIST optimisation.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraMailboxPathV3Table.NAMESPACE, DataTypes.TEXT).withPartitionKey(CassandraMailboxPathV3Table.USER, DataTypes.TEXT).withClusteringColumn(CassandraMailboxPathV3Table.MAILBOX_NAME, DataTypes.TEXT).withColumn(CassandraMailboxPathV3Table.MAILBOX_ID, DataTypes.TIMEUUID).withColumn(CassandraMailboxPathV3Table.UIDVALIDITY, DataTypes.BIGINT)).build();
}

