/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.probe.ACLProbe;
import org.apache.james.utils.GuiceProbe;

public class ACLProbeImpl
implements GuiceProbe,
ACLProbe {
    private static final boolean RESET_RECENT = false;
    private final MailboxManager mailboxManager;

    @Inject
    private ACLProbeImpl(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public void replaceRights(MailboxPath mailboxPath, String targetUser, MailboxACL.Rfc4314Rights rights) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(mailboxPath.getUser());
        MailboxACL.ACLCommand command = MailboxACL.command().forUser(Username.of((String)targetUser)).rights(rights).asReplacement();
        this.mailboxManager.applyRightsCommand(mailboxPath, command, mailboxSession);
    }

    public void addRights(MailboxPath mailboxPath, String targetUser, MailboxACL.Rfc4314Rights rights) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(mailboxPath.getUser());
        MailboxACL.ACLCommand command = MailboxACL.command().forUser(Username.of((String)targetUser)).rights(rights).asAddition();
        this.mailboxManager.applyRightsCommand(mailboxPath, command, mailboxSession);
    }

    public MailboxACL retrieveRights(MailboxPath mailboxPath) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(mailboxPath.getUser());
        return this.mailboxManager.getMailbox(mailboxPath, mailboxSession).getMetaData(MessageManager.MailboxMetaData.RecentMode.IGNORE, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT).getACL();
    }
}

