/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataCmdHandler;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesDataCmdHandler
extends DataCmdHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesDataCmdHandler.class);

    @Inject
    public JamesDataCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    protected SMTPResponse doDATA(SMTPSession session, String argument) {
        try {
            MimeMessageInputStreamSource mmiss = MimeMessageInputStreamSource.create((String)MailImpl.getId());
            ExtendedSMTPSession extendedSMTPSession = (ExtendedSMTPSession)session;
            extendedSMTPSession.setMimeMessageInputStreamSource(mmiss);
        }
        catch (Exception e) {
            LOGGER.warn("Error creating mimemessagesource for incoming data", (Throwable)e);
            return new SMTPResponse("451", (CharSequence)"Unexpected error preparing to receive DATA.");
        }
        session.pushLineHandler(this.getLineHandler());
        return new SMTPResponse("354", (CharSequence)"Ok Send data ending with <CRLF>.<CRLF>");
    }
}

