/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;

public class ResourceUtils {
    public static final String URL_PROTOCOL_FILE = "file";

    public static File getFile(URL url, String description) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(url.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + url);
        }
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }
}

