/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class AbstractConnectionPool
implements FullLDAPInterface,
Closeable {
    @Override
    public abstract void close();

    public abstract void close(boolean var1, int var2);

    public abstract boolean isClosed();

    @NotNull
    public abstract LDAPConnection getConnection() throws LDAPException;

    public abstract void releaseConnection(@NotNull LDAPConnection var1);

    public abstract void releaseDefunctConnection(@NotNull LDAPConnection var1);

    public final void releaseConnectionAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) {
        LDAPConnectionPoolHealthCheck healthCheck = this.getHealthCheck();
        try {
            healthCheck.ensureConnectionValidAfterException(connection, exception);
            this.releaseConnection(connection);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.releaseDefunctConnection(connection);
        }
    }

    @NotNull
    public abstract LDAPConnection replaceDefunctConnection(@NotNull LDAPConnection var1) throws LDAPException;

    @NotNull
    private LDAPConnection replaceDefunctConnection(@NotNull Throwable t, @NotNull LDAPConnection connection) throws LDAPException {
        try {
            return this.replaceDefunctConnection(connection);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            if (t instanceof LDAPException) {
                throw (LDAPException)t;
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
        }
    }

    public final boolean retryFailedOperationsDueToInvalidConnections() {
        return !this.getOperationTypesToRetryDueToInvalidConnections().isEmpty();
    }

    @NotNull
    public abstract Set<OperationType> getOperationTypesToRetryDueToInvalidConnections();

    public final void setRetryFailedOperationsDueToInvalidConnections(boolean retryFailedOperationsDueToInvalidConnections) {
        if (retryFailedOperationsDueToInvalidConnections) {
            this.setRetryFailedOperationsDueToInvalidConnections(EnumSet.allOf(OperationType.class));
        } else {
            this.setRetryFailedOperationsDueToInvalidConnections(EnumSet.noneOf(OperationType.class));
        }
    }

    public abstract void setRetryFailedOperationsDueToInvalidConnections(@Nullable Set<OperationType> var1);

    public abstract int getCurrentAvailableConnections();

    public abstract int getMaximumAvailableConnections();

    @NotNull
    public abstract LDAPConnectionPoolStatistics getConnectionPoolStatistics();

    @Nullable
    public abstract String getConnectionPoolName();

    public abstract void setConnectionPoolName(@Nullable String var1);

    @NotNull
    public abstract LDAPConnectionPoolHealthCheck getHealthCheck();

    public abstract long getHealthCheckIntervalMillis();

    public abstract void setHealthCheckIntervalMillis(long var1);

    protected abstract void doHealthCheck();

    @Override
    @Nullable
    public final RootDSE getRootDSE() throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            RootDSE rootDSE = conn.getRootDSE();
            this.releaseConnection(conn);
            return rootDSE;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.SEARCH, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                RootDSE rootDSE = newConn.getRootDSE();
                this.releaseConnection(newConn);
                return rootDSE;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @Nullable
    public final Schema getSchema() throws LDAPException {
        return this.getSchema("");
    }

    @Override
    @Nullable
    public final Schema getSchema(@Nullable String entryDN) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            Schema schema = conn.getSchema(entryDN);
            this.releaseConnection(conn);
            return schema;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.SEARCH, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                Schema schema = newConn.getSchema(entryDN);
                this.releaseConnection(newConn);
                return schema;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @Nullable
    public final SearchResultEntry getEntry(@NotNull String dn) throws LDAPException {
        return this.getEntry(dn, StaticUtils.NO_STRINGS);
    }

    @Override
    @Nullable
    public final SearchResultEntry getEntry(@NotNull String dn, String ... attributes) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            SearchResultEntry entry = conn.getEntry(dn, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.SEARCH, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                SearchResultEntry entry = newConn.getEntry(dn, attributes);
                this.releaseConnection(newConn);
                return entry;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult add(@NotNull String dn, Attribute ... attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public final LDAPResult add(@NotNull String dn, @NotNull Collection<Attribute> attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public final LDAPResult add(@NotNull Entry entry) throws LDAPException {
        return this.add(new AddRequest(entry));
    }

    @Override
    @NotNull
    public final LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    @Override
    @NotNull
    public final LDAPResult add(@NotNull AddRequest addRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(addRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.ADD, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                LDAPResult result = newConn.add(addRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult add(@NotNull ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add((AddRequest)addRequest);
    }

    @Override
    @NotNull
    public final BindResult bind(@Nullable String bindDN, @Nullable String password) throws LDAPException {
        return this.bind(new SimpleBindRequest(bindDN, password));
    }

    @Override
    @NotNull
    public final BindResult bind(@NotNull BindRequest bindRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            BindResult result = conn.bind(bindRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.BIND, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                BindResult result = newConn.bind(bindRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final CompareResult compare(@NotNull String dn, @NotNull String attributeName, @NotNull String assertionValue) throws LDAPException {
        return this.compare(new CompareRequest(dn, attributeName, assertionValue));
    }

    @Override
    @NotNull
    public final CompareResult compare(@NotNull CompareRequest compareRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            CompareResult result = conn.compare(compareRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.COMPARE, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                CompareResult result = newConn.compare(compareRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final CompareResult compare(@NotNull ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare((CompareRequest)compareRequest);
    }

    @Override
    @NotNull
    public final LDAPResult delete(@NotNull String dn) throws LDAPException {
        return this.delete(new DeleteRequest(dn));
    }

    @Override
    @NotNull
    public final LDAPResult delete(@NotNull DeleteRequest deleteRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.delete(deleteRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.DELETE, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                LDAPResult result = newConn.delete(deleteRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult delete(@NotNull ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)deleteRequest);
    }

    @Override
    @NotNull
    public final ExtendedResult processExtendedOperation(@NotNull String requestOID) throws LDAPException {
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    @Override
    @NotNull
    public final ExtendedResult processExtendedOperation(@NotNull String requestOID, @Nullable ASN1OctetString requestValue) throws LDAPException {
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    @Override
    @NotNull
    public final ExtendedResult processExtendedOperation(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        if (extendedRequest.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_POOL_STARTTLS_NOT_ALLOWED.get());
        }
        LDAPConnection conn = this.getConnection();
        try {
            ExtendedResult result = conn.processExtendedOperation(extendedRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.EXTENDED, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                ExtendedResult result = newConn.processExtendedOperation(extendedRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult modify(@NotNull String dn, @NotNull Modification mod) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mod));
    }

    @Override
    @NotNull
    public final LDAPResult modify(@NotNull String dn, Modification ... mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public final LDAPResult modify(@NotNull String dn, @NotNull List<Modification> mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public final LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.modify(new ModifyRequest(ldifModificationLines));
    }

    @Override
    @NotNull
    public final LDAPResult modify(@NotNull ModifyRequest modifyRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(modifyRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.MODIFY, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                LDAPResult result = newConn.modify(modifyRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult modify(@NotNull ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)modifyRequest);
    }

    @Override
    @NotNull
    public final LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN));
    }

    @Override
    @NotNull
    public final LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN, newSuperiorDN));
    }

    @Override
    @NotNull
    public final LDAPResult modifyDN(@NotNull ModifyDNRequest modifyDNRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modifyDN(modifyDNRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPExceptionIfShouldNotRetry(t, OperationType.MODIFY_DN, conn);
            LDAPConnection newConn = this.replaceDefunctConnection(t, conn);
            try {
                LDAPResult result = newConn.modifyDN(modifyDNRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final LDAPResult modifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)modifyDNRequest);
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            LDAPConnection newConn;
            this.throwLDAPSearchExceptionIfShouldNotRetry(t, conn);
            try {
                newConn = this.replaceDefunctConnection(t, conn);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPSearchException(le);
            }
            try {
                SearchResult result = newConn.search(searchRequest);
                this.releaseConnection(newConn);
                return result;
            }
            catch (Throwable t2) {
                this.throwLDAPSearchException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @NotNull
    public final SearchResult search(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)searchRequest);
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, filter, attributes));
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, AbstractConnectionPool.parseFilter(filter), attributes));
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(searchRequest);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            LDAPConnection newConn;
            this.throwLDAPSearchExceptionIfShouldNotRetry(t, conn);
            try {
                newConn = this.replaceDefunctConnection(t, conn);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPSearchException(le);
            }
            try {
                SearchResultEntry entry = newConn.searchForEntry(searchRequest);
                this.releaseConnection(newConn);
                return entry;
            }
            catch (Throwable t2) {
                this.throwLDAPSearchException(t2, newConn);
                return null;
            }
        }
    }

    @Override
    @Nullable
    public final SearchResultEntry searchForEntry(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)searchRequest);
    }

    @NotNull
    private static Filter parseFilter(@NotNull String filterString) throws LDAPSearchException {
        try {
            return Filter.create(filterString);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LDAPResult> processRequests(@NotNull List<LDAPRequest> requests, boolean continueOnError) throws LDAPException {
        ArrayList<LDAPResult> results;
        block15: {
            LDAPConnection conn;
            Validator.ensureNotNull(requests);
            Validator.ensureFalse(requests.isEmpty(), "LDAPConnectionPool.processRequests.requests must not be empty.");
            try {
                conn = this.getConnection();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPSearchException(le);
            }
            results = new ArrayList<LDAPResult>(requests.size());
            boolean isDefunct = false;
            try {
                block10: for (LDAPRequest request : requests) {
                    try {
                        LDAPResult result = conn.processOperation(request);
                        results.add(result);
                        switch (result.getResultCode().intValue()) {
                            case 0: 
                            case 5: 
                            case 6: 
                            case 16654: {
                                break;
                            }
                            default: {
                                if (!ResultCode.isConnectionUsable(result.getResultCode())) {
                                    isDefunct = true;
                                }
                                if (continueOnError) continue block10;
                                break block15;
                            }
                        }
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        results.add(new LDAPResult(request.getLastMessageID(), le.getResultCode(), le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), le.getResponseControls()));
                        if (!ResultCode.isConnectionUsable(le.getResultCode())) {
                            isDefunct = true;
                        }
                        if (continueOnError) continue;
                        break;
                    }
                }
            }
            finally {
                if (isDefunct) {
                    this.releaseDefunctConnection(conn);
                } else {
                    this.releaseConnection(conn);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<AsyncRequestID> processRequestsAsync(@NotNull List<LDAPRequest> requests, long maxWaitTimeMillis) throws LDAPException {
        LDAPConnection conn;
        Validator.ensureNotNull(requests);
        Validator.ensureFalse(requests.isEmpty(), "LDAPConnectionPool.processRequests.requests must not be empty.");
        block21: for (LDAPRequest r : requests) {
            switch (r.getOperationType()) {
                case ADD: 
                case COMPARE: 
                case DELETE: 
                case MODIFY: 
                case MODIFY_DN: {
                    continue block21;
                }
                case SEARCH: {
                    SearchRequest searchRequest = (SearchRequest)r;
                    if (searchRequest.getSearchResultListener() != null && searchRequest.getSearchResultListener() instanceof AsyncSearchResultListener) continue block21;
                    throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_SEARCH_NOT_ASYNC.get(String.valueOf(r)));
                }
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_OP_NOT_ASYNC.get(String.valueOf(r)));
        }
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        ArrayList<AsyncRequestID> requestIDs = new ArrayList<AsyncRequestID>(requests.size());
        boolean isDefunct = false;
        try {
            if (conn.synchronousMode()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_SYNCHRONOUS_MODE.get());
            }
            for (LDAPRequest r : requests) {
                AsyncRequestID requestID = null;
                try {
                    switch (r.getOperationType()) {
                        case ADD: {
                            requestID = conn.asyncAdd((AddRequest)r, null);
                            break;
                        }
                        case COMPARE: {
                            requestID = conn.asyncCompare((CompareRequest)r, null);
                            break;
                        }
                        case DELETE: {
                            requestID = conn.asyncDelete((DeleteRequest)r, null);
                            break;
                        }
                        case MODIFY: {
                            requestID = conn.asyncModify((ModifyRequest)r, null);
                            break;
                        }
                        case MODIFY_DN: {
                            requestID = conn.asyncModifyDN((ModifyDNRequest)r, null);
                            break;
                        }
                        case SEARCH: {
                            requestID = conn.asyncSearch((SearchRequest)r);
                        }
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    requestID = new AsyncRequestID(r.getLastMessageID(), conn);
                    requestID.setResult(le.toLDAPResult());
                }
                requestIDs.add(requestID);
            }
            long startWaitingTime = System.currentTimeMillis();
            long stopWaitingTime = maxWaitTimeMillis > 0L ? startWaitingTime + maxWaitTimeMillis : Long.MAX_VALUE;
            for (AsyncRequestID requestID : requestIDs) {
                LDAPResult result;
                long waitTime = stopWaitingTime - System.currentTimeMillis();
                if (waitTime > 0L) {
                    try {
                        result = requestID.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        requestID.cancel(true);
                        result = e instanceof TimeoutException ? new LDAPResult(requestID.getMessageID(), ResultCode.TIMEOUT, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_TIMEOUT.get(System.currentTimeMillis() - startWaitingTime), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new LDAPResult(requestID.getMessageID(), ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_EXCEPTION.get(StaticUtils.getExceptionMessage(e)), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                        requestID.setResult(result);
                    }
                } else {
                    requestID.cancel(true);
                    result = new LDAPResult(requestID.getMessageID(), ResultCode.TIMEOUT, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_TIMEOUT.get(System.currentTimeMillis() - startWaitingTime), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                    requestID.setResult(result);
                }
                if (ResultCode.isConnectionUsable(result.getResultCode())) continue;
                isDefunct = true;
            }
            ArrayList<AsyncRequestID> arrayList = requestIDs;
            return arrayList;
        }
        finally {
            if (isDefunct) {
                this.releaseDefunctConnection(conn);
            } else {
                this.releaseConnection(conn);
            }
        }
    }

    private void throwLDAPExceptionIfShouldNotRetry(@NotNull Throwable t, @NotNull OperationType o, @NotNull LDAPConnection conn) throws LDAPException {
        if (t instanceof LDAPException && this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)o)) {
            LDAPException le = (LDAPException)t;
            LDAPConnectionPoolHealthCheck healthCheck = this.getHealthCheck();
            try {
                healthCheck.ensureConnectionValidAfterException(conn, le);
            }
            catch (Exception e) {
                Debug.debugException(e);
                return;
            }
        }
        this.throwLDAPException(t, conn);
    }

    private void throwLDAPSearchExceptionIfShouldNotRetry(@NotNull Throwable t, @NotNull LDAPConnection conn) throws LDAPSearchException {
        if (t instanceof LDAPException && this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)OperationType.SEARCH)) {
            LDAPException le = (LDAPException)t;
            LDAPConnectionPoolHealthCheck healthCheck = this.getHealthCheck();
            try {
                healthCheck.ensureConnectionValidAfterException(conn, le);
            }
            catch (Exception e) {
                Debug.debugException(e);
                return;
            }
        }
        this.throwLDAPSearchException(t, conn);
    }

    void throwLDAPException(@NotNull Throwable t, @NotNull LDAPConnection conn) throws LDAPException {
        Debug.debugException(t);
        if (t instanceof LDAPException) {
            LDAPException le = (LDAPException)t;
            this.releaseConnectionAfterException(conn, le);
            throw le;
        }
        this.releaseDefunctConnection(conn);
        StaticUtils.rethrowIfError(t);
        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
    }

    void throwLDAPSearchException(@NotNull Throwable t, @NotNull LDAPConnection conn) throws LDAPSearchException {
        Debug.debugException(t);
        if (t instanceof LDAPException) {
            LDAPSearchException lse = t instanceof LDAPSearchException ? (LDAPSearchException)t : new LDAPSearchException((LDAPException)t);
            this.releaseConnectionAfterException(conn, lse);
            throw lse;
        }
        this.releaseDefunctConnection(conn);
        StaticUtils.rethrowIfError(t);
        throw new LDAPSearchException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);
}

