/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.Locales;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ImmutableStatusResponse;

public class StatusResponseEncoder
implements ImapResponseEncoder<ImmutableStatusResponse> {
    private final Localizer localizer;

    @Inject
    public StatusResponseEncoder(Localizer localizer) {
        this.localizer = localizer;
    }

    @Override
    public Class<ImmutableStatusResponse> acceptableMessages() {
        return ImmutableStatusResponse.class;
    }

    @Override
    public void encode(ImmutableStatusResponse response, ImapResponseComposer composer) throws IOException {
        boolean useParens;
        long number;
        Collection<String> parameters;
        StatusResponse.Type serverResponseType = response.getServerResponseType();
        byte[] type = this.asBytes(serverResponseType);
        StatusResponse.ResponseCode responseCode = response.getResponseCode();
        String code = this.asString(responseCode);
        Tag tag = response.getTag();
        ImapCommand command = response.getCommand();
        HumanReadableText textKey = response.getTextKey();
        String text = this.asString(textKey);
        if (responseCode == null) {
            parameters = null;
            number = -1L;
            useParens = false;
        } else {
            parameters = responseCode.getParameters();
            number = responseCode.getNumber();
            useParens = responseCode.useParens();
        }
        if (tag == null) {
            composer.untagged();
        } else {
            composer.tag(tag);
        }
        composer.message(type);
        if (responseCode != null) {
            composer.openSquareBracket();
            composer.message(code);
            if (number > -1L) {
                composer.message(number);
            }
            if (parameters != null && !parameters.isEmpty()) {
                if (useParens) {
                    composer.openParen();
                }
                for (String parameter : parameters) {
                    composer.message(parameter);
                }
                if (useParens) {
                    composer.closeParen();
                }
            }
            composer.closeSquareBracket();
        }
        if (command != null) {
            composer.commandName(command);
        }
        if (text != null && !text.isEmpty()) {
            composer.message(text);
        }
        composer.end();
    }

    private String asString(HumanReadableText text) {
        return this.localizer.localize(text, Locales.DEFAULT);
    }

    private String asString(StatusResponse.ResponseCode code) {
        if (code == null) {
            return null;
        }
        return code.getCode();
    }

    private byte[] asBytes(StatusResponse.Type type) {
        if (type == null) {
            return null;
        }
        return type.getCodeAsBytes();
    }
}

