/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.system;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystemControl;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphTxnCtl
extends DatasetGraphWrapper
implements TransactionalSystemControl {
    private ReadWriteLock exclusivitylock = new ReentrantReadWriteLock();
    private ReadWriteLock writeableDatabase = new ReentrantReadWriteLock();

    public DatasetGraphTxnCtl(DatasetGraph dsg) {
        super(dsg);
    }

    public DatasetGraphTxnCtl(DatasetGraph dsg, Context context) {
        super(dsg, context);
    }

    public void begin(TxnType txnType) {
        Objects.nonNull(txnType);
        this.checkNotActive();
        this.enterTransaction(txnType, true);
        super.begin(txnType);
    }

    protected final void checkNotActive() {
        if (this.isInTransaction()) {
            throw new TransactionException(this.label("Currently in an active transaction"));
        }
    }

    private String label(String msg) {
        return msg;
    }

    protected final void checkActive() {
        if (!this.isInTransaction()) {
            throw new TransactionException(this.label("Not in an active transaction"));
        }
    }

    public void begin(ReadWrite readWrite) {
        Objects.nonNull(readWrite);
        this.begin(TxnType.convert((ReadWrite)readWrite));
    }

    private void enterTransaction(TxnType txnType, boolean canBlock) {
        boolean canBlockWriters = canBlock;
        boolean bExclusive = this.tryNonExclusiveMode(canBlock);
        if (!bExclusive) {
            throw new TransactionException("Can't start transaction at the moment.");
        }
        switch (txnType) {
            case READ: {
                break;
            }
            case READ_COMMITTED_PROMOTE: 
            case READ_PROMOTE: 
            case WRITE: {
                this.startPossibleWriter();
            }
        }
    }

    private void exitTransaction(TxnType txnType) {
        switch (txnType) {
            case READ: {
                break;
            }
            case READ_COMMITTED_PROMOTE: 
            case READ_PROMOTE: 
            case WRITE: {
                this.finishPossibleWriter();
            }
        }
        this.finishNonExclusiveMode();
    }

    public void commit() {
        TxnType txnType = this.transactionType();
        super.commit();
        this.exitTransaction(txnType);
    }

    public void abort() {
        TxnType txnType = this.transactionType();
        super.abort();
        this.exitTransaction(txnType);
    }

    public void end() {
        TxnType txnType = this.transactionType();
        boolean inTxn = this.isInTransaction();
        super.end();
        if (inTxn) {
            this.exitTransaction(txnType);
        }
    }

    public void startReadOnlyDatabase() {
        this.startReadOnly();
    }

    public void finishReadOnlyDatabase() {
        this.finishReadOnly();
    }

    protected void startReadOnly() {
        this.startReadOnly(true);
    }

    protected void startReadOnly(boolean canBlock) {
        DatasetGraphTxnCtl.beginSingleMode(this.writeableDatabase, canBlock);
    }

    protected void finishReadOnly() {
        DatasetGraphTxnCtl.endSingleMode(this.writeableDatabase);
    }

    protected void startPossibleWriter() {
        DatasetGraphTxnCtl.beginMultiMode(this.writeableDatabase, true);
    }

    protected void startPossibleWriter(boolean canBlock) {
        DatasetGraphTxnCtl.beginMultiMode(this.writeableDatabase, canBlock);
    }

    protected void finishPossibleWriter() {
        DatasetGraphTxnCtl.endMultiMode(this.writeableDatabase);
    }

    public void startNonExclusiveMode() {
        boolean b = DatasetGraphTxnCtl.beginMultiMode(this.exclusivitylock, true);
        if (!b) {
            throw new TransactionException("Can't start transaction at the moment.");
        }
    }

    public boolean tryNonExclusiveMode(boolean canBlock) {
        return DatasetGraphTxnCtl.beginMultiMode(this.exclusivitylock, canBlock);
    }

    public void finishNonExclusiveMode() {
        DatasetGraphTxnCtl.endMultiMode(this.exclusivitylock);
    }

    public void startExclusiveMode() {
        this.startExclusiveMode(true);
    }

    private boolean startExclusiveMode(boolean canBlock) {
        if (canBlock) {
            this.exclusivitylock.writeLock().lock();
            return true;
        }
        return this.exclusivitylock.writeLock().tryLock();
    }

    public boolean tryExclusiveMode() {
        return this.tryExclusiveMode(false);
    }

    public boolean tryExclusiveMode(boolean canBlock) {
        return this.startExclusiveMode(canBlock);
    }

    public void finishExclusiveMode() {
        this.exclusivitylock.writeLock().unlock();
    }

    private static boolean beginMultiMode(ReadWriteLock lock, boolean canBlock) {
        if (!canBlock) {
            return lock.readLock().tryLock();
        }
        lock.readLock().lock();
        return true;
    }

    private static void endMultiMode(ReadWriteLock lock) {
        lock.readLock().unlock();
    }

    private static boolean beginSingleMode(ReadWriteLock lock, boolean canBlock) {
        if (!canBlock) {
            return lock.writeLock().tryLock();
        }
        lock.writeLock().lock();
        return true;
    }

    private static void endSingleMode(ReadWriteLock lock) {
        lock.writeLock().unlock();
    }
}

