/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="This is the model for CM server information from v41.  The class models the host environment that CM server is installed. Each CM server instance has an entry of CmServer entity and updates it periodically.")
public class ApiCmServer {
    @SerializedName(value="cmServerId")
    private String cmServerId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="ipAddress")
    private String ipAddress = null;
    @SerializedName(value="createdTime")
    private String createdTime = null;
    @SerializedName(value="lastUpdatedTime")
    private String lastUpdatedTime = null;
    @SerializedName(value="haPriority")
    private String haPriority = null;
    @SerializedName(value="isAlive")
    private String isAlive = null;

    public ApiCmServer cmServerId(String cmServerId) {
        this.cmServerId = cmServerId;
        return this;
    }

    @Schema(description="The CM server ID.")
    public String getCmServerId() {
        return this.cmServerId;
    }

    public void setCmServerId(String cmServerId) {
        this.cmServerId = cmServerId;
    }

    public ApiCmServer name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The CM server hostname.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCmServer ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Schema(description="The IP address.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ApiCmServer createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Schema(description="The created time.")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public ApiCmServer lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @Schema(description="The last updated time.")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public ApiCmServer haPriority(String haPriority) {
        this.haPriority = haPriority;
        return this;
    }

    @Schema(description="HA Priority for active passive mode.")
    public String getHaPriority() {
        return this.haPriority;
    }

    public void setHaPriority(String haPriority) {
        this.haPriority = haPriority;
    }

    public ApiCmServer isAlive(String isAlive) {
        this.isAlive = isAlive;
        return this;
    }

    @Schema(description="Is the cm server running.")
    public String getIsAlive() {
        return this.isAlive;
    }

    public void setIsAlive(String isAlive) {
        this.isAlive = isAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCmServer apiCmServer = (ApiCmServer)o;
        return Objects.equals(this.cmServerId, apiCmServer.cmServerId) && Objects.equals(this.name, apiCmServer.name) && Objects.equals(this.ipAddress, apiCmServer.ipAddress) && Objects.equals(this.createdTime, apiCmServer.createdTime) && Objects.equals(this.lastUpdatedTime, apiCmServer.lastUpdatedTime) && Objects.equals(this.haPriority, apiCmServer.haPriority) && Objects.equals(this.isAlive, apiCmServer.isAlive);
    }

    public int hashCode() {
        return Objects.hash(this.cmServerId, this.name, this.ipAddress, this.createdTime, this.lastUpdatedTime, this.haPriority, this.isAlive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCmServer {\n");
        sb.append("    cmServerId: ").append(this.toIndentedString(this.cmServerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    haPriority: ").append(this.toIndentedString(this.haPriority)).append("\n");
        sb.append("    isAlive: ").append(this.toIndentedString(this.isAlive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

