/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndKubernetesResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.InstanceResource;
import org.apache.linkis.manager.common.entity.resource.KubernetesResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.SpecialResource;
import org.apache.linkis.manager.common.entity.resource.UserResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String toJSONString(T entity) {
        String json = null;
        try {
            json = mapper.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            logger.warn("to json string met with exception", (Throwable)e);
        }
        return json;
    }

    public static <T> T parse(String json, TypeReference<T> valueTypeRef) {
        try {
            return (T)mapper.readValue(json, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            logger.warn("json parse met with exception", (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            logger.warn("json parse met with exception", (Throwable)e);
            return null;
        }
    }

    public static Resource deserializeResource(String plainResource, ResourceType resourceType) {
        try {
            switch (resourceType) {
                case CPU: {
                    return (Resource)mapper.readValue(plainResource, CPUResource.class);
                }
                case DriverAndYarn: {
                    return (Resource)mapper.readValue(plainResource, DriverAndYarnResource.class);
                }
                case Instance: {
                    return (Resource)mapper.readValue(plainResource, InstanceResource.class);
                }
                case LoadInstance: {
                    return (Resource)mapper.readValue(plainResource, LoadInstanceResource.class);
                }
                case Load: {
                    return (Resource)mapper.readValue(plainResource, LoadResource.class);
                }
                case Memory: {
                    return (Resource)mapper.readValue(plainResource, MemoryResource.class);
                }
                case Special: {
                    return (Resource)mapper.readValue(plainResource, SpecialResource.class);
                }
                case Yarn: {
                    return (Resource)mapper.readValue(plainResource, YarnResource.class);
                }
                case DriverAndKubernetes: {
                    return (Resource)mapper.readValue(plainResource, DriverAndKubernetesResource.class);
                }
                case Kubernetes: {
                    return (Resource)mapper.readValue(plainResource, KubernetesResource.class);
                }
            }
            return (Resource)mapper.readValue(plainResource, LoadResource.class);
        }
        catch (JsonProcessingException e) {
            logger.warn("ResourceUtils deserializeResource failed", (Throwable)e);
            return null;
        }
    }

    public static String serializeResource(Resource resource) {
        try {
            return mapper.writeValueAsString((Object)resource);
        }
        catch (JsonProcessingException e) {
            logger.warn("ResourceUtils deserializeResource failed", (Throwable)e);
            return null;
        }
    }

    public static PersistenceResource toPersistenceResource(NodeResource nodeResource) {
        PersistenceResource persistenceResource = new PersistenceResource();
        if (nodeResource.getMaxResource() != null) {
            persistenceResource.setMaxResource(ResourceUtils.serializeResource(nodeResource.getMaxResource()));
        }
        if (nodeResource.getMinResource() != null) {
            persistenceResource.setMinResource(ResourceUtils.serializeResource(nodeResource.getMinResource()));
        }
        if (nodeResource.getLockedResource() != null) {
            persistenceResource.setLockedResource(ResourceUtils.serializeResource(nodeResource.getLockedResource()));
        }
        if (nodeResource.getExpectedResource() != null) {
            persistenceResource.setExpectedResource(ResourceUtils.serializeResource(nodeResource.getExpectedResource()));
        }
        if (nodeResource.getLeftResource() != null) {
            persistenceResource.setLeftResource(ResourceUtils.serializeResource(nodeResource.getLeftResource()));
        }
        if (nodeResource.getUsedResource() != null) {
            persistenceResource.setUsedResource(ResourceUtils.serializeResource(nodeResource.getUsedResource()));
        }
        persistenceResource.setResourceType(nodeResource.getResourceType().toString());
        return persistenceResource;
    }

    public static CommonNodeResource fromPersistenceResource(PersistenceResource persistenceResource) {
        if (persistenceResource == null) {
            return null;
        }
        CommonNodeResource nodeResource = new CommonNodeResource();
        ResourceType resourceType = ResourceType.valueOf(persistenceResource.getResourceType());
        nodeResource.setId(persistenceResource.getId());
        if (persistenceResource.getMaxResource() != null) {
            nodeResource.setMaxResource(ResourceUtils.deserializeResource(persistenceResource.getMaxResource(), resourceType));
        }
        if (persistenceResource.getMinResource() != null) {
            nodeResource.setMinResource(ResourceUtils.deserializeResource(persistenceResource.getMinResource(), resourceType));
        }
        if (persistenceResource.getLockedResource() != null) {
            nodeResource.setLockedResource(ResourceUtils.deserializeResource(persistenceResource.getLockedResource(), resourceType));
        }
        if (persistenceResource.getExpectedResource() != null) {
            nodeResource.setExpectedResource(ResourceUtils.deserializeResource(persistenceResource.getExpectedResource(), resourceType));
        }
        if (persistenceResource.getLeftResource() != null) {
            nodeResource.setLeftResource(ResourceUtils.deserializeResource(persistenceResource.getLeftResource(), resourceType));
        }
        if (persistenceResource.getUsedResource() != null) {
            nodeResource.setUsedResource(ResourceUtils.deserializeResource(persistenceResource.getUsedResource(), resourceType));
        }
        if (persistenceResource.getCreateTime() != null) {
            nodeResource.setCreateTime(persistenceResource.getCreateTime());
        }
        if (persistenceResource.getUpdateTime() != null) {
            nodeResource.setUpdateTime(persistenceResource.getUpdateTime());
        }
        nodeResource.setResourceType(resourceType);
        return nodeResource;
    }

    public static UserResource fromPersistenceResourceAndUser(PersistenceResource persistenceResource) {
        if (persistenceResource == null) {
            return null;
        }
        UserResource nodeResource = new UserResource();
        nodeResource.setId(persistenceResource.getId());
        ResourceType resourceType = ResourceType.valueOf(persistenceResource.getResourceType());
        if (persistenceResource.getMaxResource() != null) {
            nodeResource.setMaxResource(ResourceUtils.deserializeResource(persistenceResource.getMaxResource(), resourceType));
        }
        if (persistenceResource.getMinResource() != null) {
            nodeResource.setMinResource(ResourceUtils.deserializeResource(persistenceResource.getMinResource(), resourceType));
        }
        if (persistenceResource.getLockedResource() != null) {
            nodeResource.setLockedResource(ResourceUtils.deserializeResource(persistenceResource.getLockedResource(), resourceType));
        }
        if (persistenceResource.getExpectedResource() != null) {
            nodeResource.setExpectedResource(ResourceUtils.deserializeResource(persistenceResource.getExpectedResource(), resourceType));
        }
        if (persistenceResource.getLeftResource() != null) {
            nodeResource.setLeftResource(ResourceUtils.deserializeResource(persistenceResource.getLeftResource(), resourceType));
        }
        if (persistenceResource.getUsedResource() != null) {
            nodeResource.setUsedResource(ResourceUtils.deserializeResource(persistenceResource.getUsedResource(), resourceType));
        }
        if (persistenceResource.getCreateTime() != null) {
            nodeResource.setCreateTime(persistenceResource.getCreateTime());
        }
        if (persistenceResource.getUpdateTime() != null) {
            nodeResource.setUpdateTime(persistenceResource.getUpdateTime());
        }
        nodeResource.setResourceType(resourceType);
        return nodeResource;
    }

    public static ResourceType getResourceTypeByResource(Resource resource) {
        if (resource instanceof LoadResource) {
            return ResourceType.Load;
        }
        if (resource instanceof InstanceResource) {
            return ResourceType.Instance;
        }
        if (resource instanceof CPUResource) {
            return ResourceType.CPU;
        }
        if (resource instanceof LoadInstanceResource) {
            return ResourceType.LoadInstance;
        }
        if (resource instanceof YarnResource) {
            return ResourceType.Yarn;
        }
        if (resource instanceof DriverAndYarnResource) {
            return ResourceType.DriverAndYarn;
        }
        if (resource instanceof SpecialResource) {
            return ResourceType.Special;
        }
        if (resource instanceof KubernetesResource) {
            return ResourceType.Kubernetes;
        }
        if (resource instanceof DriverAndKubernetesResource) {
            return ResourceType.DriverAndKubernetes;
        }
        return ResourceType.LoadInstance;
    }

    public static NodeResource convertTo(NodeResource nodeResource, ResourceType resourceType) {
        if (nodeResource.getResourceType().equals((Object)resourceType)) {
            return nodeResource;
        }
        if (resourceType.equals((Object)ResourceType.LoadInstance) && nodeResource.getResourceType().equals((Object)ResourceType.DriverAndYarn)) {
            DriverAndYarnResource lockedResource;
            nodeResource.setResourceType(resourceType);
            if (nodeResource.getMaxResource() != null) {
                DriverAndYarnResource maxResource = (DriverAndYarnResource)nodeResource.getMaxResource();
                nodeResource.setMaxResource(maxResource.getLoadInstanceResource());
            }
            if (nodeResource.getMinResource() != null) {
                DriverAndYarnResource minResource = (DriverAndYarnResource)nodeResource.getMinResource();
                nodeResource.setMinResource(minResource.getLoadInstanceResource());
            }
            if (nodeResource.getUsedResource() != null) {
                DriverAndYarnResource usedResource = (DriverAndYarnResource)nodeResource.getUsedResource();
                nodeResource.setUsedResource(usedResource.getLoadInstanceResource());
            }
            if (nodeResource.getLockedResource() != null) {
                lockedResource = (DriverAndYarnResource)nodeResource.getLockedResource();
                nodeResource.setLockedResource(lockedResource.getLoadInstanceResource());
            }
            if (nodeResource.getExpectedResource() != null) {
                lockedResource = (DriverAndYarnResource)nodeResource.getExpectedResource();
                nodeResource.setExpectedResource(lockedResource.getLoadInstanceResource());
            }
            if (nodeResource.getLeftResource() != null && nodeResource.getLeftResource() instanceof DriverAndYarnResource) {
                DriverAndYarnResource leftResource = (DriverAndYarnResource)nodeResource.getLeftResource();
                nodeResource.setLeftResource(leftResource.getLoadInstanceResource());
            }
            return nodeResource;
        }
        return nodeResource;
    }

    public static float getLoadInstanceResourceRate(Resource leftResource, Resource maxResource) {
        if (null == leftResource) {
            return 0.0f;
        }
        if (null == maxResource) {
            return 1.0f;
        }
        if (leftResource instanceof LoadInstanceResource) {
            if (maxResource instanceof LoadInstanceResource) {
                LoadInstanceResource leftLoadInstanceResource = (LoadInstanceResource)leftResource;
                LoadInstanceResource maxLoadInstanceResource = (LoadInstanceResource)maxResource;
                float cpuRate = maxLoadInstanceResource.getCores() > 0 ? (float)leftLoadInstanceResource.getCores() * 1.0f / (float)maxLoadInstanceResource.getCores() : 1.0f;
                float memoryRate = maxLoadInstanceResource.getMemory() > 0L ? (float)leftLoadInstanceResource.getMemory() * 1.0f / (float)maxLoadInstanceResource.getMemory() : 1.0f;
                float instanceRate = maxLoadInstanceResource.getInstances() > 0 ? (float)leftLoadInstanceResource.getInstances() * 1.0f / (float)maxLoadInstanceResource.getInstances() : 1.0f;
                return Math.min(Math.min(cpuRate, memoryRate), instanceRate);
            }
            return 1.0f;
        }
        return 1.0f;
    }

    static {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
    }
}

