/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.SpecialMap;
import org.apache.linkis.cli.application.interactor.command.template.converter.AbstractStringConverter;

public class PredefinedStringConverters {
    public static final AbstractStringConverter<String> NO_CONVERTER = new AbstractStringConverter<String>(){

        @Override
        public String convert(String from) {
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            return from;
        }
    };
    public static final AbstractStringConverter<String[]> STR_ARRAY_CONVERTER = new AbstractStringConverter<String[]>(){

        @Override
        public String[] convert(String from) {
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            String[] ret = from.trim().split("@#@");
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = StringUtils.strip((String)ret[i], (String)" \"");
            }
            return ret;
        }
    };
    public static final AbstractStringConverter<Map<String, String>> STRING_MAP_CONVERTER = new AbstractStringConverter<Map<String, String>>(){

        @Override
        public Map<String, String> convert(String from) {
            String[] arr;
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            HashMap<String, String> paraMap = new HashMap<String, String>();
            for (String prop : arr = from.trim().split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
                int index = (prop = prop.trim()).indexOf("=");
                if (index == -1) {
                    throw new CommandException("CMD0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "Illegal Input: " + from + ". Input should be a Map described by kv-pairs. e.g. key1=value1,key2=value2");
                }
                paraMap.put(StringUtils.strip((String)prop.substring(0, index).trim(), (String)" \""), StringUtils.strip((String)prop.substring(index + 1).trim(), (String)" \""));
            }
            return paraMap;
        }
    };
    public static final AbstractStringConverter<SpecialMap<String, String>> STRING_SPECIAL_MAP_CONVERTER = new AbstractStringConverter<SpecialMap<String, String>>(){

        @Override
        public SpecialMap<String, String> convert(String from) {
            String[] arr;
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            SpecialMap<String, String> paraMap = new SpecialMap<String, String>();
            for (String prop : arr = from.trim().split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
                int index = (prop = prop.trim()).indexOf("=");
                if (index == -1) {
                    throw new CommandException("CMD0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "Illegal Input: " + from + ". Input should be a Map described by kv-pairs. e.g. key1=value1,key2=value2");
                }
                paraMap.put(StringUtils.strip((String)prop.substring(0, index).trim(), (String)" \""), StringUtils.strip((String)prop.substring(index + 1).trim(), (String)" \""));
            }
            return paraMap;
        }
    };
    public static final AbstractStringConverter<Boolean> BOOLEAN_CONVERTER = new AbstractStringConverter<Boolean>(){

        @Override
        public Boolean convert(String from) {
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            return Boolean.valueOf(from);
        }
    };
    public static final AbstractStringConverter<Integer> INT_CONVERTER = new AbstractStringConverter<Integer>(){

        @Override
        public Integer convert(String from) {
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            return Integer.valueOf(from);
        }
    };
    public static final AbstractStringConverter<Long> LONG_CONVERTER = new AbstractStringConverter<Long>(){

        @Override
        public Long convert(String from) {
            return Long.valueOf(from);
        }
    };
    public static final AbstractStringConverter<List<Long>> LONG_ARRAY_CONVERTER = new AbstractStringConverter<List<Long>>(){

        @Override
        public List<Long> convert(String from) {
            if (StringUtils.isBlank((CharSequence)from)) {
                return null;
            }
            String[] split = from.split("\\s*,\\s*");
            if (split.length <= 0) {
                return new ArrayList<Long>(0);
            }
            ArrayList<Long> ret = new ArrayList<Long>(split.length);
            for (String str : split) {
                if ("".equals(str)) continue;
                ret.add(Long.valueOf(str));
            }
            return ret;
        }
    };
}

