/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template.option;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.template.option.BaseOption;

public class MapOption
extends BaseOption<Map<String, String>>
implements Cloneable {
    final String[] paramNames;

    public MapOption(String keyPrefix, String key, String[] paramNames, String description, boolean isOptional) {
        super(keyPrefix, key, description, isOptional, null, null);
        this.paramNames = paramNames;
        this.value = new HashMap();
    }

    public MapOption(String keyPrefix, String key, String[] paramNames, String description, boolean isOptional, Map<String, String> value) {
        super(keyPrefix, key, description, isOptional, null, null);
        this.paramNames = paramNames;
        this.value = value;
    }

    public String toString() {
        Map defaultValue = (Map)this.value;
        String description = this.getDescription();
        StringBuilder sb = new StringBuilder();
        sb.append("\t").append(StringUtils.join((Object[])this.paramNames, (String)"|")).append(" <").append(defaultValue.getClass().getSimpleName()).append(">").append(System.lineSeparator());
        sb.append("\t\t").append(description).append(System.lineSeparator());
        sb.append("\t\tdefault by: ").append("null").append(System.lineSeparator());
        sb.append("\t\toptional:").append(this.isOptional());
        return sb.toString();
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    @Override
    public void setValueWithStr(String value) throws IllegalArgumentException {
        try {
            this.rawVal = this.rawVal + "#@#" + value;
            this.value = this.parseKvAndPut((Map)this.value, value);
            this.hasVal = true;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, String> parseKvAndPut(Map<String, String> kvMap, String rawVal) {
        String value;
        String key;
        int index = (rawVal = rawVal.trim()).indexOf("=");
        if (index != -1) {
            key = rawVal.substring(0, index).trim();
            value = StringUtils.strip((String)rawVal.substring(index + 1).trim(), (String)" \"");
            if (kvMap.containsKey(key) && !StringUtils.equals((CharSequence)kvMap.get(key), (CharSequence)value)) {
                String msg = MessageFormat.format("Multiple values for same key were found! Option: \"{0}\", key: \"{1}\"", this.getParamName(), key);
                throw new IllegalArgumentException(msg);
            }
        } else {
            throw new CommandException("CMD0021", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "Illegal Input: " + rawVal + ". Input should be a Map-entry described by kv-pairs. e.g. key1=value1");
        }
        kvMap.put(key, value);
        return kvMap;
    }

    @Override
    public String getParamName() {
        return StringUtils.join((Object[])this.paramNames, (String)"|");
    }

    @Override
    public MapOption clone() throws CloneNotSupportedException {
        MapOption ret = (MapOption)super.clone();
        ret.value = new HashMap((Map)this.value);
        return ret;
    }
}

