/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import java.text.MessageFormat;
import org.apache.linkis.cli.application.constants.CliConstants;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.LogData;
import org.apache.linkis.cli.application.observer.event.LinkisClientEvent;
import org.apache.linkis.cli.application.observer.event.LogStartEvent;
import org.apache.linkis.cli.application.observer.listener.LinkisClientListener;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.apache.linkis.cli.application.utils.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRetriever {
    private static final Logger logger = LoggerFactory.getLogger(LogRetriever.class);
    private LinkisJobOper linkisJobOperator;
    private LogData logData;
    private Boolean incLogMode;
    private LinkisClientListener logListener;
    private LinkisClientEvent logStartEvent = new LogStartEvent();

    public LogRetriever(String user, String jobId, String execId, Boolean incLogMode, LinkisJobOper linkisJobOperator, LinkisClientListener logListener) {
        this.linkisJobOperator = linkisJobOperator;
        this.logListener = logListener;
        this.incLogMode = incLogMode;
        this.logData = new LogData(user, jobId, execId);
        this.registerLogListener(logListener);
    }

    public void retrieveLogAsync() {
        if (this.logData.getUser() == null || this.logData.getJobID() == null) {
            throw new LinkisClientExecutionException("EXE0036", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "user or jobID is null");
        }
        try {
            Thread logConsumer = new Thread(() -> this.notifyLogListener(), "Log-Consumer");
            Thread logRetriever = new Thread(() -> this.queryLogLoop(this.logData), "Log-Retriever");
            SchedulerManager.getCachedThreadPoolExecutor().execute(logRetriever);
            SchedulerManager.getCachedThreadPoolExecutor().execute(logConsumer);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve log", (Throwable)e);
        }
    }

    public void waitIncLogComplete() {
        int retry = 0;
        int MAX_RETRY = 300;
        while (retry++ < MAX_RETRY) {
            if (this.logFinReceived()) {
                return;
            }
            CliUtils.doSleepQuietly(CliConstants.JOB_QUERY_SLEEP_MILLS);
        }
        String msg = "Job is in Finished state(SUCCEED/FAILED/CANCELED) but client keep querying inclog for " + (long)MAX_RETRY * CliConstants.JOB_QUERY_SLEEP_MILLS / 1000L + "seconds. Execution ends forcefully. Next will try handle execution result.";
        logger.warn(msg);
        LoggerManager.getInformationLogger().warn(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryLogLoop(LogData data) {
        boolean hasNext = true;
        int retryCnt = 0;
        int MAX_RETRY = 12;
        try {
            while (hasNext) {
                int nextLogIdx;
                int curLogIdx = data.getNextLogLineIdx() == null ? 0 : data.getNextLogLineIdx();
                try {
                    this.queryJobLogFromLine(data, curLogIdx);
                }
                catch (Exception e) {
                    logger.error("Cannot get inc-log:", (Throwable)e);
                    if (++retryCnt >= 12) {
                        logger.error("Continuously failing to query inc-log for 84s. Will no longer try to query log", (Throwable)e);
                        break;
                    }
                    CliUtils.doSleepQuietly(500L + 500L * (long)retryCnt);
                    continue;
                }
                retryCnt = 0;
                int n = nextLogIdx = data.getNextLogLineIdx() == null ? curLogIdx : data.getNextLogLineIdx();
                if (this.incLogMode.booleanValue()) {
                    hasNext = data.hasNextLogLine() == null ? curLogIdx < nextLogIdx : data.hasNextLogLine();
                } else {
                    boolean bl = hasNext = curLogIdx < nextLogIdx;
                }
                if (curLogIdx >= nextLogIdx) {
                    String msg = MessageFormat.format("Retrieving log, curLogIdx={}, hasNext={0}, nextLogIdx={1}", curLogIdx, hasNext, nextLogIdx);
                    logger.info(msg);
                }
                CliUtils.doSleepQuietly(CliConstants.JOB_QUERY_SLEEP_MILLS);
            }
        }
        catch (Exception e) {
            logger.error("Something goes wrong. Job Log may be incomplete", (Throwable)e);
        }
        finally {
            this.sendLogFin();
        }
    }

    private void queryJobLogFromLine(LogData data, int fromLine) throws LinkisClientRuntimeException {
        LinkisOperResultAdapter jobInfoResult = this.linkisJobOperator.queryJobInfo(data.getUser(), data.getJobID());
        data.updateLog(jobInfoResult);
        if (!jobInfoResult.getJobStatus().isJobFinishedState()) {
            data.updateLog(this.linkisJobOperator.queryRunTimeLogFromLine(data.getUser(), data.getJobID(), data.getExecID(), fromLine));
        } else {
            data.updateLog(this.linkisJobOperator.queryPersistedLogFromLine(data.getLogPath(), data.getUser(), data.getJobID(), fromLine));
        }
    }

    public Boolean isIncLogMode() {
        return this.incLogMode;
    }

    public void registerLogListener(LinkisClientListener observer) {
        this.logStartEvent.register(observer);
    }

    public void notifyLogListener() {
        if (this.logStartEvent.isRegistered()) {
            this.logStartEvent.notifyObserver(this.logStartEvent, this.logData);
        }
    }

    public void sendLogFin() {
        this.logData.setLogFin();
    }

    public boolean logFinReceived() {
        return this.logData.isLogFin();
    }
}

