/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.validate;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.ValidateException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.operator.ujes.UJESClientContext;

public class UJESContextValidator {
    public void doValidation(UJESClientContext context) throws LinkisClientRuntimeException {
        boolean ok = true;
        StringBuilder reasonSb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)context.getGatewayUrl())) {
            reasonSb.append("gatewayUrl cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)context.getAuthenticationStrategyStr())) {
            reasonSb.append("Authentication Strategy cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        } else if (!"static".equalsIgnoreCase(context.getAuthenticationStrategyStr()) && !"token".equalsIgnoreCase(context.getAuthenticationStrategyStr())) {
            reasonSb.append("Authentication Strategy ").append(context.getAuthenticationStrategyStr()).append(" is not valid");
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)context.getTokenKey())) {
            reasonSb.append("tokenKey cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)context.getTokenKey())) {
            reasonSb.append("tokenValue cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (!ok) {
            throw new ValidateException("VLD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "LinkisJob validation failed. Reason: " + reasonSb.toString());
        }
    }
}

