/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.service;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.engineplugin.spark.datacalc.exception.DatabaseNotSupportException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataSource;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.ClickHouseStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DB2Strategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DataSourceStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DmStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DorisStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.KingbaseStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.MySqlStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.OracleStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.PostgreSqlStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.SqlServerStrategy;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.TiDBStrategy;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;

public class LinkisDataSourceContext {
    private static final Map<String, DataSourceStrategy> dsStrategyMap = new HashMap<String, DataSourceStrategy>();
    private final DataSourceStrategy dataSourceStrategy;
    private final DataSource datasource;

    public LinkisDataSourceContext(DataSource ds) {
        this.datasource = ds;
        String databaseType = ds.getDataSourceType() == null ? "" : ds.getDataSourceType().getName();
        this.dataSourceStrategy = this.getDataSourceStrategy(databaseType);
    }

    private DataSourceStrategy getDataSourceStrategy(String databaseType) {
        if (dsStrategyMap.containsKey(databaseType)) {
            return dsStrategyMap.get(databaseType);
        }
        int code = SparkErrorCodeSummary.DATA_CALC_DATABASE_NOT_SUPPORT.getErrorCode();
        String errDesc = SparkErrorCodeSummary.DATA_CALC_DATABASE_NOT_SUPPORT.getErrorDesc();
        String msg = MessageFormat.format(errDesc, this.datasource.getDataSourceName(), databaseType);
        throw new DatabaseNotSupportException(code, msg);
    }

    public DataCalcDataSource getDataCalcDataSource() {
        Map connectParams = this.datasource.getConnectParams();
        Map<Object, Object> params = new HashMap(0);
        if (connectParams != null) {
            params = connectParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        }
        String defaultDriver = this.dataSourceStrategy.defaultDriver();
        String paramsJson = params.getOrDefault("params", "{}");
        String defaultPort = this.dataSourceStrategy.defaultPort();
        String address = params.getOrDefault("address", "");
        if (StringUtils.isBlank((CharSequence)address)) {
            String host = (String)params.getOrDefault("host", "");
            String port = (String)params.getOrDefault("port", defaultPort);
            address = host + ":" + port;
        }
        DataCalcDataSource ds = new DataCalcDataSource();
        ds.setDriver((String)params.getOrDefault("driverClassName", defaultDriver));
        ds.setUser((String)params.getOrDefault("username", ""));
        ds.setPassword((String)params.getOrDefault("password", ""));
        ds.setUrl(this.dataSourceStrategy.getJdbcUrl(address, params, paramsJson));
        return ds;
    }

    static {
        dsStrategyMap.put("mysql", new MySqlStrategy());
        dsStrategyMap.put("tidb", new TiDBStrategy());
        dsStrategyMap.put("doris", new DorisStrategy());
        dsStrategyMap.put("starrocks", new DorisStrategy());
        dsStrategyMap.put("dm", new DmStrategy());
        dsStrategyMap.put("kingbase", new KingbaseStrategy());
        dsStrategyMap.put("postgresql", new PostgreSqlStrategy());
        dsStrategyMap.put("gaussdb", new PostgreSqlStrategy());
        dsStrategyMap.put("clickhouse", new ClickHouseStrategy());
        dsStrategyMap.put("oracle", new OracleStrategy());
        dsStrategyMap.put("sqlserver", new SqlServerStrategy());
        dsStrategyMap.put("db2", new DB2Strategy());
    }
}

